using System;
using System.Drawing;
using System.Collections;
using System.Text;
using System.ComponentModel;
using System.Windows.Forms;

namespace QCGM.Forms
{
	/// <summary>
	/// Summary description for qcConsole.
	/// </summary>
	public class QcConsole : System.Windows.Forms.Form
	{
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuViewTop;
		private System.Windows.Forms.MenuItem menuOnTop;
		private System.Windows.Forms.MenuItem menuOpacity;
		private System.Windows.Forms.MenuItem menuOpacity25;
		private System.Windows.Forms.MenuItem menuOpacity50;
		private System.Windows.Forms.MenuItem menuOpacity75;
		private System.Windows.Forms.MenuItem menuOpacity100;
		private System.Windows.Forms.ContextMenu rtbContextMenu;
		private System.Windows.Forms.MenuItem menuCopy;
		private System.Windows.Forms.MenuItem menuSelectAll;
		private System.Windows.Forms.TextBox tbInput;
		private System.Windows.Forms.RichTextBox rtbConsole;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuFileTop;
		private System.Windows.Forms.MenuItem menuSaveAs;
		private System.Windows.Forms.MenuItem menuClear;

		private string consoleFileName;
		private System.Windows.Forms.SaveFileDialog saveFileDialog;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuClose;

		private Object Synchronizer = "Synchronizer object";

		public QcConsole()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			consoleFileName = "";
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.rtbContextMenu = new System.Windows.Forms.ContextMenu();
			this.menuCopy = new System.Windows.Forms.MenuItem();
			this.menuSelectAll = new System.Windows.Forms.MenuItem();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuFileTop = new System.Windows.Forms.MenuItem();
			this.menuSaveAs = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuClear = new System.Windows.Forms.MenuItem();
			this.menuViewTop = new System.Windows.Forms.MenuItem();
			this.menuOpacity = new System.Windows.Forms.MenuItem();
			this.menuOpacity25 = new System.Windows.Forms.MenuItem();
			this.menuOpacity50 = new System.Windows.Forms.MenuItem();
			this.menuOpacity75 = new System.Windows.Forms.MenuItem();
			this.menuOpacity100 = new System.Windows.Forms.MenuItem();
			this.menuOnTop = new System.Windows.Forms.MenuItem();
			this.tbInput = new System.Windows.Forms.TextBox();
			this.rtbConsole = new System.Windows.Forms.RichTextBox();
			this.saveFileDialog = new System.Windows.Forms.SaveFileDialog();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuClose = new System.Windows.Forms.MenuItem();
			this.SuspendLayout();
			// 
			// rtbContextMenu
			// 
			this.rtbContextMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						   this.menuCopy,
																						   this.menuSelectAll});
			this.rtbContextMenu.Popup += new System.EventHandler(this.contextMenu1_Popup);
			// 
			// menuCopy
			// 
			this.menuCopy.Index = 0;
			this.menuCopy.Text = "&Copy";
			this.menuCopy.Click += new System.EventHandler(this.menuCopy_Click);
			// 
			// menuSelectAll
			// 
			this.menuSelectAll.Index = 1;
			this.menuSelectAll.Text = "Select &All";
			this.menuSelectAll.Click += new System.EventHandler(this.menuSelectAll_Click);
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuFileTop,
																					  this.menuViewTop});
			// 
			// menuFileTop
			// 
			this.menuFileTop.Index = 0;
			this.menuFileTop.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						this.menuSaveAs,
																						this.menuItem6,
																						this.menuClear,
																						this.menuItem1,
																						this.menuClose});
			this.menuFileTop.Text = "&File";
			// 
			// menuSaveAs
			// 
			this.menuSaveAs.Index = 0;
			this.menuSaveAs.Text = "&Save As...";
			this.menuSaveAs.Click += new System.EventHandler(this.menuSaveAs_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 1;
			this.menuItem6.Text = "-";
			// 
			// menuClear
			// 
			this.menuClear.Index = 2;
			this.menuClear.Text = "&Clear All Text";
			this.menuClear.Click += new System.EventHandler(this.menuClear_Click);
			// 
			// menuViewTop
			// 
			this.menuViewTop.Index = 1;
			this.menuViewTop.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						this.menuOnTop,
																						this.menuOpacity});
			this.menuViewTop.Text = "&View";
			// 
			// menuOpacity
			// 
			this.menuOpacity.Index = 1;
			this.menuOpacity.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						this.menuOpacity25,
																						this.menuOpacity50,
																						this.menuOpacity75,
																						this.menuOpacity100});
			this.menuOpacity.Text = "&Opacity";
			// 
			// menuOpacity25
			// 
			this.menuOpacity25.Index = 0;
			this.menuOpacity25.RadioCheck = true;
			this.menuOpacity25.Text = "&25%";
			this.menuOpacity25.Click += new System.EventHandler(this.menuOpacity25_Click);
			// 
			// menuOpacity50
			// 
			this.menuOpacity50.Index = 1;
			this.menuOpacity50.RadioCheck = true;
			this.menuOpacity50.Text = "&50%";
			this.menuOpacity50.Click += new System.EventHandler(this.menuOpacity50_Click);
			// 
			// menuOpacity75
			// 
			this.menuOpacity75.Index = 2;
			this.menuOpacity75.RadioCheck = true;
			this.menuOpacity75.Text = "&75%";
			this.menuOpacity75.Click += new System.EventHandler(this.menuOpacity75_Click);
			// 
			// menuOpacity100
			// 
			this.menuOpacity100.Checked = true;
			this.menuOpacity100.Index = 3;
			this.menuOpacity100.RadioCheck = true;
			this.menuOpacity100.Text = "&100%";
			this.menuOpacity100.Click += new System.EventHandler(this.menuOpacity100_Click);
			// 
			// menuOnTop
			// 
			this.menuOnTop.Index = 0;
			this.menuOnTop.Text = "&Always On Top";
			this.menuOnTop.Click += new System.EventHandler(this.menuOnTop_Click);
			// 
			// tbInput
			// 
			this.tbInput.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.tbInput.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.tbInput.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.tbInput.Location = new System.Drawing.Point(0, 324);
			this.tbInput.Name = "tbInput";
			this.tbInput.Size = new System.Drawing.Size(424, 21);
			this.tbInput.TabIndex = 14;
			this.tbInput.Text = "Enter commands here.";
			this.tbInput.KeyDown += new System.Windows.Forms.KeyEventHandler(this.tbInput_KeyPress);
			this.tbInput.TextChanged += new System.EventHandler(this.tbInput_TextChanged);
			this.tbInput.DoubleClick += new System.EventHandler(this.tbInput_DoubleClick);
			this.tbInput.Enter += new System.EventHandler(this.tbInput_Enter);
			// 
			// rtbConsole
			// 
			this.rtbConsole.AutoSize = true;
			this.rtbConsole.AutoWordSelection = true;
			this.rtbConsole.ContextMenu = this.rtbContextMenu;
			this.rtbConsole.Dock = System.Windows.Forms.DockStyle.Fill;
			this.rtbConsole.Font = new System.Drawing.Font("Arial", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.rtbConsole.HideSelection = false;
			this.rtbConsole.Location = new System.Drawing.Point(0, 0);
			this.rtbConsole.Name = "rtbConsole";
			this.rtbConsole.ReadOnly = true;
			this.rtbConsole.ScrollBars = System.Windows.Forms.RichTextBoxScrollBars.ForcedVertical;
			this.rtbConsole.ShowSelectionMargin = true;
			this.rtbConsole.Size = new System.Drawing.Size(424, 324);
			this.rtbConsole.TabIndex = 15;
			this.rtbConsole.Text = "";
			// 
			// saveFileDialog
			// 
			this.saveFileDialog.DefaultExt = "txt";
			this.saveFileDialog.Filter = "Text Files|*.txt|All files|*.*";
			this.saveFileDialog.Title = "Save Console Text As...";
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 3;
			this.menuItem1.Text = "-";
			// 
			// menuClose
			// 
			this.menuClose.Index = 4;
			this.menuClose.Text = "&Close";
			this.menuClose.Click += new System.EventHandler(this.menuClose_Click_1);
			// 
			// QcConsole
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(424, 345);
			this.Controls.Add(this.rtbConsole);
			this.Controls.Add(this.tbInput);
			this.Menu = this.mainMenu1;
			this.MinimumSize = new System.Drawing.Size(320, 240);
			this.Name = "QcConsole";
			this.Text = "Console";
			this.ResumeLayout(false);

		}
		#endregion

		protected override void OnClosing(CancelEventArgs e)
		{
			lock(Synchronizer)
			{
				this.Hide();
			}

			//check here to see if the form can close. if not...
			e.Cancel = true;
		}

		private void menuOnTop_Click(object sender, System.EventArgs e)
		{
			lock(Synchronizer)
			{
				if (this.TopMost == true)
				{
					this.TopMost = false;
					this.menuOnTop.Checked = false;
				}
				else
				{
					this.TopMost = true;
					this.menuOnTop.Checked = true;
				}
			}
		}


		private void menuOpacity25_Click(object sender, System.EventArgs e)
		{
			lock(Synchronizer)
			{
				this.Opacity = 0.25;
			}
			this.menuOpacity25.Checked = true;
			this.menuOpacity50.Checked = false;
			this.menuOpacity75.Checked = false;
			this.menuOpacity100.Checked = false;
		}

		private void menuOpacity50_Click(object sender, System.EventArgs e)
		{
			lock(Synchronizer)
			{
				this.Opacity = 0.50;
			}
			this.menuOpacity25.Checked = false;
			this.menuOpacity50.Checked = true;
			this.menuOpacity75.Checked = false;
			this.menuOpacity100.Checked = false;
		}

		private void menuOpacity75_Click(object sender, System.EventArgs e)
		{
			lock(Synchronizer)
			{
				this.Opacity = 0.75;
			}
			this.menuOpacity25.Checked = false;
			this.menuOpacity50.Checked = false;
			this.menuOpacity75.Checked = true;
			this.menuOpacity100.Checked = false;
		}

		private void menuOpacity100_Click(object sender, System.EventArgs e)
		{
			lock(Synchronizer)
			{
				this.Opacity = 1.00;
			}
			this.menuOpacity25.Checked = false;
			this.menuOpacity50.Checked = false;
			this.menuOpacity75.Checked = false;
			this.menuOpacity100.Checked = true;
		}

		private void contextMenu1_Popup(object sender, System.EventArgs e)
		{
			if (this.rtbConsole.SelectionLength > 0) {
				this.menuCopy.Enabled = true;
			} else {
				this.menuCopy.Enabled = false;
			}
		}

		private void menuCopy_Click(object sender, System.EventArgs e)
		{
			lock(Synchronizer)
			{
				this.rtbConsole.Copy();
			}
		}

		private void menuSelectAll_Click(object sender, System.EventArgs e)
		{
			lock(Synchronizer)
			{
				this.rtbConsole.SelectAll();
			}
		}

		private void menuClear_Click(object sender, System.EventArgs e)
		{
			DialogResult result = MessageBox.Show("Are you sure you want to clear the console window?", "Confirmation", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
			if (result == DialogResult.Yes)
			{
				lock(Synchronizer)
				{
					this.rtbConsole.Clear();
					this.Refresh();
				}
			}
			else
			{
				// do nothing
			}
		}

		private void menuSave_Click(object sender, System.EventArgs e)
		{
			lock(Synchronizer)
			{
				if (this.consoleFileName == "" || !System.IO.File.Exists(consoleFileName))
				{
					DialogResult result = saveFileDialog.ShowDialog(this);
					if (result == DialogResult.OK)
					{
						consoleFileName = saveFileDialog.FileName;
						this.rtbConsole.SaveFile(consoleFileName, RichTextBoxStreamType.PlainText);
					}
					else
					{
						return; // without doing anything
					}
				} 
				else 
				{
					this.rtbConsole.SaveFile(consoleFileName, RichTextBoxStreamType.PlainText);
				}
			}
		}


		/// <summary>
		/// Delegate functions control events. This function acts as a bridge.
		/// </summary>
		/// <param name="e"></param>
		protected virtual void PostEvent(string text)
		{
			if (EventHandler != null)
				EventHandler(this, text);
		}

		public delegate void ConsoleEventHandler(object sender, string text);

		public event ConsoleEventHandler EventHandler;


		private void tbInput_KeyPress(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Enter)
			{
				lock(Synchronizer)
				{
					if (this.tbInput.Text.Length > 0)
					{
						WriteLine("> " + this.tbInput.Text);
						
						
						PostEvent(this.tbInput.Text);
						//ActiveClient.SendMessage("move right");
						// Send string to server to send to all clients.
						this.tbInput.Text = "";
					}
				}
			}
		}

		public void WriteLine(string text)
		{
			lock(Synchronizer)
			{
				//rtbConsole.Text += text + System.Environment.NewLine;
				
				int end = rtbConsole.Text.Length;
				rtbConsole.AppendText(text + System.Environment.NewLine);

				int result = rtbConsole.Find("Server:", end, RichTextBoxFinds.MatchCase);
				if (result > -1)
				{
					rtbConsole.Select(result, 7);
					rtbConsole.SelectionFont = new Font("Arial", 10, FontStyle.Bold);
					rtbConsole.SelectionColor = Color.Red;
					rtbConsole.Select(0, 0);
				}
				
				rtbConsole.AppendText("");
				//rtbConsole.ScrollToCaret();
				//this.rtbConsole.AppendText(text + System.Environment.NewLine);
			}
		}

		private void tbInput_Enter(object sender, System.EventArgs e)
		{
			lock(Synchronizer)
			{
				this.tbInput.SelectAll();
			}
		}

		private void menuSaveAs_Click(object sender, System.EventArgs e)
		{
			DialogResult result = saveFileDialog.ShowDialog(this);
			if (result == DialogResult.OK)
			{
				lock(Synchronizer)
				{
					consoleFileName = saveFileDialog.FileName;
					this.rtbConsole.SaveFile(consoleFileName, RichTextBoxStreamType.PlainText);
				}
			}
			else
			{
				return; // without doing anything
			}
		}

		private void menuClose_Click_1(object sender, System.EventArgs e)
		{
			lock(Synchronizer)
			{
				this.Hide();
			}
		}

		private void tbInput_TextChanged(object sender, System.EventArgs e)
		{
		
		}

		private void tbInput_DoubleClick(object sender, System.EventArgs e)
		{
			lock(Synchronizer)
			{
				this.tbInput.SelectAll();
			}
		}
	}
}
