using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Net;
using QCGM;

namespace QCGM.Forms
{
	/// <summary>
	/// Summary description for CreateNewGame.
	/// </summary>
	public class CreateNewGame : System.Windows.Forms.Form
	{
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.CheckBox checkBoxP1Networked;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox tbP1Name;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.TextBox tbP2Name;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.CheckBox checkBoxP2Networked;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.Label label4;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.TextBox tbServerName;
		private System.Windows.Forms.Button buttonReset;
		private System.Windows.Forms.TextBox tbServerPort;

		//public NewGameSettings newGameSettings = null;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.TextBox tbIPAddress;

		private string hostName = "";
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.TextBox tbHostName;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox tbTimeLimit;
		private System.Windows.Forms.TabControl tabControl1;
		private System.Windows.Forms.TabPage tabPage1;
		private System.Windows.Forms.TabPage tabPage2;
		private System.Windows.Forms.CheckBox checkBoxTimeLimit;
		private System.Windows.Forms.Label label7;
		private string ipAddress = "127.0.0.1";

		public CreateNewGame(Settings defaults)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			this.tbServerName.Text = defaults.ServerName;
			this.tbTimeLimit.Text = defaults.TimeLimit.ToString();
			this.tbServerPort.Text = defaults.ServerListenPort.ToString();
			this.tbP1Name.Text = defaults.Player1Name;
			this.tbP2Name.Text = defaults.Player2Name;
			this.checkBoxTimeLimit.Checked = defaults.UseTimeLimit;

			this.hostName = Dns.GetHostName();
			this.ipAddress = Dns.GetHostByName(hostName).AddressList[0].ToString();

			if (this.hostName != "")
			{
				this.tbHostName.Text = this.hostName;
			}
			
			if (this.ipAddress != "")
			{
				this.tbIPAddress.Text = ipAddress;
			}
			else
			{
				this.tbIPAddress.Text = "127.0.0.1";
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(CreateNewGame));
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.tbP1Name = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.checkBoxP1Networked = new System.Windows.Forms.CheckBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.tbP2Name = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.checkBoxP2Networked = new System.Windows.Forms.CheckBox();
			this.btnOK = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.label4 = new System.Windows.Forms.Label();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.checkBoxTimeLimit = new System.Windows.Forms.CheckBox();
			this.tbTimeLimit = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.tbHostName = new System.Windows.Forms.TextBox();
			this.label6 = new System.Windows.Forms.Label();
			this.tbIPAddress = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.buttonReset = new System.Windows.Forms.Button();
			this.tbServerPort = new System.Windows.Forms.TextBox();
			this.label9 = new System.Windows.Forms.Label();
			this.tbServerName = new System.Windows.Forms.TextBox();
			this.label8 = new System.Windows.Forms.Label();
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.tabControl1 = new System.Windows.Forms.TabControl();
			this.tabPage1 = new System.Windows.Forms.TabPage();
			this.tabPage2 = new System.Windows.Forms.TabPage();
			this.label7 = new System.Windows.Forms.Label();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.groupBox3.SuspendLayout();
			this.tabControl1.SuspendLayout();
			this.tabPage1.SuspendLayout();
			this.tabPage2.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox1
			// 
			this.groupBox1.BackColor = System.Drawing.SystemColors.Control;
			this.groupBox1.Controls.Add(this.tbP1Name);
			this.groupBox1.Controls.Add(this.label1);
			this.groupBox1.Controls.Add(this.checkBoxP1Networked);
			this.groupBox1.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox1.Location = new System.Drawing.Point(8, 64);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(392, 80);
			this.groupBox1.TabIndex = 0;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Player 1";
			// 
			// tbP1Name
			// 
			this.tbP1Name.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.tbP1Name.Location = new System.Drawing.Point(72, 16);
			this.tbP1Name.Name = "tbP1Name";
			this.tbP1Name.Size = new System.Drawing.Size(208, 21);
			this.tbP1Name.TabIndex = 1;
			this.tbP1Name.Text = "Player 1";
			this.tbP1Name.TextChanged += new System.EventHandler(this.tbP1Name_TextChanged);
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(56, 23);
			this.label1.TabIndex = 18;
			this.label1.Text = "Name :";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.label1.UseMnemonic = false;
			// 
			// checkBoxP1Networked
			// 
			this.checkBoxP1Networked.Enabled = false;
			this.checkBoxP1Networked.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.checkBoxP1Networked.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.checkBoxP1Networked.Location = new System.Drawing.Point(72, 48);
			this.checkBoxP1Networked.Name = "checkBoxP1Networked";
			this.checkBoxP1Networked.Size = new System.Drawing.Size(288, 24);
			this.checkBoxP1Networked.TabIndex = 2;
			this.checkBoxP1Networked.Text = "This player will be controlled from across the network.";
			this.checkBoxP1Networked.CheckedChanged += new System.EventHandler(this.checkBoxP1Networked_CheckedChanged);
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.tbP2Name);
			this.groupBox2.Controls.Add(this.label2);
			this.groupBox2.Controls.Add(this.checkBoxP2Networked);
			this.groupBox2.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox2.Location = new System.Drawing.Point(8, 152);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(392, 80);
			this.groupBox2.TabIndex = 3;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Player 2";
			// 
			// tbP2Name
			// 
			this.tbP2Name.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.tbP2Name.Location = new System.Drawing.Point(72, 16);
			this.tbP2Name.Name = "tbP2Name";
			this.tbP2Name.Size = new System.Drawing.Size(208, 21);
			this.tbP2Name.TabIndex = 4;
			this.tbP2Name.Text = "Player 2";
			this.tbP2Name.TextChanged += new System.EventHandler(this.tbP2Name_TextChanged);
			// 
			// label2
			// 
			this.label2.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label2.Location = new System.Drawing.Point(8, 16);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(56, 23);
			this.label2.TabIndex = 17;
			this.label2.Text = "Name :";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.label2.UseMnemonic = false;
			// 
			// checkBoxP2Networked
			// 
			this.checkBoxP2Networked.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.checkBoxP2Networked.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.checkBoxP2Networked.Location = new System.Drawing.Point(72, 48);
			this.checkBoxP2Networked.Name = "checkBoxP2Networked";
			this.checkBoxP2Networked.Size = new System.Drawing.Size(296, 24);
			this.checkBoxP2Networked.TabIndex = 5;
			this.checkBoxP2Networked.Text = "This player will be controlled from across the network.";
			this.checkBoxP2Networked.CheckedChanged += new System.EventHandler(this.checkBoxP2Networked_CheckedChanged);
			// 
			// btnOK
			// 
			this.btnOK.BackColor = System.Drawing.SystemColors.Control;
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnOK.Location = new System.Drawing.Point(344, 280);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 12;
			this.btnOK.Text = "OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.BackColor = System.Drawing.SystemColors.Control;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnCancel.Location = new System.Drawing.Point(16, 280);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 13;
			this.btnCancel.Text = "Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// label4
			// 
			this.label4.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label4.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label4.Location = new System.Drawing.Point(16, 8);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(384, 48);
			this.label4.TabIndex = 19;
			this.label4.Text = "Enter your name if you want to play Quoridor from this computer, or let the playe" +
				"r be controlled from across the network.";
			// 
			// groupBox3
			// 
			this.groupBox3.Controls.Add(this.checkBoxTimeLimit);
			this.groupBox3.Controls.Add(this.tbTimeLimit);
			this.groupBox3.Controls.Add(this.label3);
			this.groupBox3.Controls.Add(this.tbHostName);
			this.groupBox3.Controls.Add(this.label6);
			this.groupBox3.Controls.Add(this.tbIPAddress);
			this.groupBox3.Controls.Add(this.label5);
			this.groupBox3.Controls.Add(this.buttonReset);
			this.groupBox3.Controls.Add(this.tbServerPort);
			this.groupBox3.Controls.Add(this.label9);
			this.groupBox3.Controls.Add(this.tbServerName);
			this.groupBox3.Controls.Add(this.label8);
			this.groupBox3.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox3.Location = new System.Drawing.Point(8, 64);
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.Size = new System.Drawing.Size(392, 168);
			this.groupBox3.TabIndex = 6;
			this.groupBox3.TabStop = false;
			this.groupBox3.Text = "Server Settings";
			// 
			// checkBoxTimeLimit
			// 
			this.checkBoxTimeLimit.Checked = true;
			this.checkBoxTimeLimit.CheckState = System.Windows.Forms.CheckState.Checked;
			this.checkBoxTimeLimit.Location = new System.Drawing.Point(96, 112);
			this.checkBoxTimeLimit.Name = "checkBoxTimeLimit";
			this.checkBoxTimeLimit.Size = new System.Drawing.Size(184, 24);
			this.checkBoxTimeLimit.TabIndex = 23;
			this.checkBoxTimeLimit.Text = "Use time limit (in seconds)";
			this.checkBoxTimeLimit.CheckedChanged += new System.EventHandler(this.checkBox1_CheckedChanged);
			// 
			// tbTimeLimit
			// 
			this.tbTimeLimit.Location = new System.Drawing.Point(96, 136);
			this.tbTimeLimit.Name = "tbTimeLimit";
			this.tbTimeLimit.Size = new System.Drawing.Size(64, 20);
			this.tbTimeLimit.TabIndex = 22;
			this.tbTimeLimit.Text = "120";
			this.tbTimeLimit.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.tbTimeLimit_KeyPress);
			this.tbTimeLimit.TextChanged += new System.EventHandler(this.textBox1_TextChanged);
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 112);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(80, 16);
			this.label3.TabIndex = 21;
			this.label3.Text = "Time Limit:";
			this.label3.TextAlign = System.Drawing.ContentAlignment.BottomRight;
			// 
			// tbHostName
			// 
			this.tbHostName.Location = new System.Drawing.Point(96, 88);
			this.tbHostName.MaxLength = 10;
			this.tbHostName.Name = "tbHostName";
			this.tbHostName.ReadOnly = true;
			this.tbHostName.Size = new System.Drawing.Size(152, 20);
			this.tbHostName.TabIndex = 10;
			this.tbHostName.Text = "localhost";
			this.tbHostName.WordWrap = false;
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(8, 88);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(80, 16);
			this.label6.TabIndex = 20;
			this.label6.Text = "Host Name:";
			this.label6.TextAlign = System.Drawing.ContentAlignment.BottomRight;
			// 
			// tbIPAddress
			// 
			this.tbIPAddress.Location = new System.Drawing.Point(96, 64);
			this.tbIPAddress.MaxLength = 10;
			this.tbIPAddress.Name = "tbIPAddress";
			this.tbIPAddress.ReadOnly = true;
			this.tbIPAddress.Size = new System.Drawing.Size(152, 20);
			this.tbIPAddress.TabIndex = 9;
			this.tbIPAddress.Text = "127.0.0.1";
			this.tbIPAddress.WordWrap = false;
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(8, 64);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(80, 16);
			this.label5.TabIndex = 13;
			this.label5.Text = "IP Address:";
			this.label5.TextAlign = System.Drawing.ContentAlignment.BottomRight;
			// 
			// buttonReset
			// 
			this.buttonReset.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.buttonReset.Location = new System.Drawing.Point(336, 16);
			this.buttonReset.Name = "buttonReset";
			this.buttonReset.Size = new System.Drawing.Size(48, 23);
			this.buttonReset.TabIndex = 11;
			this.buttonReset.Text = "Reset";
			this.buttonReset.Click += new System.EventHandler(this.buttonReset_Click);
			// 
			// tbServerPort
			// 
			this.tbServerPort.Location = new System.Drawing.Point(96, 40);
			this.tbServerPort.MaxLength = 10;
			this.tbServerPort.Name = "tbServerPort";
			this.tbServerPort.Size = new System.Drawing.Size(64, 20);
			this.tbServerPort.TabIndex = 8;
			this.tbServerPort.Text = "8167";
			this.tbServerPort.WordWrap = false;
			this.tbServerPort.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.tbServerPort_KeyPress);
			this.tbServerPort.TextChanged += new System.EventHandler(this.tbServerPort_TextChanged);
			// 
			// label9
			// 
			this.label9.Location = new System.Drawing.Point(8, 40);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(80, 16);
			this.label9.TabIndex = 14;
			this.label9.Text = "Listening Port:";
			this.label9.TextAlign = System.Drawing.ContentAlignment.BottomRight;
			// 
			// tbServerName
			// 
			this.tbServerName.Location = new System.Drawing.Point(96, 16);
			this.tbServerName.MaxLength = 256;
			this.tbServerName.Name = "tbServerName";
			this.tbServerName.Size = new System.Drawing.Size(200, 20);
			this.tbServerName.TabIndex = 7;
			this.tbServerName.Text = "Quoridor Classic Game";
			this.tbServerName.TextChanged += new System.EventHandler(this.tbServerName_TextChanged);
			// 
			// label8
			// 
			this.label8.Location = new System.Drawing.Point(8, 16);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(80, 16);
			this.label8.TabIndex = 15;
			this.label8.Text = "Name:";
			this.label8.TextAlign = System.Drawing.ContentAlignment.BottomRight;
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			// 
			// tabControl1
			// 
			this.tabControl1.Controls.Add(this.tabPage1);
			this.tabControl1.Controls.Add(this.tabPage2);
			this.tabControl1.Location = new System.Drawing.Point(8, 8);
			this.tabControl1.Name = "tabControl1";
			this.tabControl1.SelectedIndex = 0;
			this.tabControl1.Size = new System.Drawing.Size(416, 264);
			this.tabControl1.TabIndex = 20;
			// 
			// tabPage1
			// 
			this.tabPage1.BackColor = System.Drawing.SystemColors.Control;
			this.tabPage1.Controls.Add(this.groupBox2);
			this.tabPage1.Controls.Add(this.groupBox1);
			this.tabPage1.Controls.Add(this.label4);
			this.tabPage1.Location = new System.Drawing.Point(4, 22);
			this.tabPage1.Name = "tabPage1";
			this.tabPage1.Size = new System.Drawing.Size(408, 238);
			this.tabPage1.TabIndex = 0;
			this.tabPage1.Text = "Player Profiles";
			// 
			// tabPage2
			// 
			this.tabPage2.Controls.Add(this.label7);
			this.tabPage2.Controls.Add(this.groupBox3);
			this.tabPage2.Location = new System.Drawing.Point(4, 22);
			this.tabPage2.Name = "tabPage2";
			this.tabPage2.Size = new System.Drawing.Size(408, 238);
			this.tabPage2.TabIndex = 1;
			this.tabPage2.Text = "Server";
			// 
			// label7
			// 
			this.label7.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label7.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label7.Location = new System.Drawing.Point(12, 8);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(384, 48);
			this.label7.TabIndex = 20;
			this.label7.Text = "Enter the name and port number of the server, and choose whether game turns have " +
				"a time limit.";
			// 
			// CreateNewGame
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.Control;
			this.ClientSize = new System.Drawing.Size(434, 312);
			this.Controls.Add(this.tabControl1);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "CreateNewGame";
			this.ShowInTaskbar = false;
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Create A New Game";
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.groupBox3.ResumeLayout(false);
			this.tabControl1.ResumeLayout(false);
			this.tabPage1.ResumeLayout(false);
			this.tabPage2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void checkBoxP1Networked_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.checkBoxP1Networked.Checked == true) 
			{
				this.tbP1Name.Enabled = false;
				this.label1.Enabled = false;
				this.checkBoxP2Networked.Enabled = false;

				if (errorProvider1.GetError(this.tbP1Name) != "")
				{
					this.tbP1Name.Text = "Player 1";
				}
				errorProvider1.SetError(this.tbP1Name, "");
			} 
			else 
			{
				this.checkBoxP2Networked.Enabled = true;
				this.tbP1Name.Enabled = true;
				this.label1.Enabled = true;
			}
		}

		private void checkBoxP2Networked_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.checkBoxP2Networked.Checked == true) 
			{
				this.tbP2Name.Enabled = false;
				this.checkBoxP1Networked.Enabled = true;

				this.label2.Enabled = false;
				if (errorProvider1.GetError(this.tbP2Name) != "")
				{
					this.tbP2Name.Text = "Player 2";
				}
				errorProvider1.SetError(this.tbP2Name, "");
			} 
			else 
			{
				this.checkBoxP1Networked.Enabled = false;
				this.tbP2Name.Enabled = true;
				this.label2.Enabled = true;
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if (errorProvider1.GetError(this.tbP1Name) != "" ||
				errorProvider1.GetError(this.tbP2Name) != "" ||
				errorProvider1.GetError(this.tbServerName) != "" ||
				errorProvider1.GetError(this.tbServerPort) != "")
			{
				System.Windows.Forms.MessageBox.Show("There are one or more errors in the form. You must correct the errors before proceeding.", "Invalid Form Entry", MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
			else
			{
				this.Close();
			}
		}

		public NewGameSettings GetSettings()
		{
			NewGameSettings settings = new NewGameSettings();
			settings.serverPort = System.Convert.ToInt32(this.tbServerPort.Text, 10);
			settings.serverName = this.tbServerName.Text;
			settings.isPlayer1Networked = this.checkBoxP1Networked.Checked;
			settings.isPlayer2Networked = this.checkBoxP2Networked.Checked;
			settings.namePlayer1 = this.tbP1Name.Text;
			settings.namePlayer2 = this.tbP2Name.Text;
			settings.hostName = this.tbHostName.Text;
			
			if(this.checkBoxTimeLimit.Checked == false)
			{
				settings.timeLimit = -1;
			}
			else
			{
				settings.timeLimit = System.Convert.ToInt32(this.tbTimeLimit.Text, 10);
			}

			return settings;
		}

		private void buttonReset_Click(object sender, System.EventArgs e)
		{
			this.tbServerName.Text = Settings.DefaultServerName;
			this.tbServerPort.Text = Settings.DefaultServerPort.ToString();
			this.tbTimeLimit.Text = "120";
			this.checkBoxTimeLimit.Checked = true;
		}

		private void tbServerPort_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			if (!Char.IsDigit(e.KeyChar) && !Char.IsControl(e.KeyChar))
			{
				e.Handled = true;
			}
		}

		private void tbP1Name_TextChanged(object sender, System.EventArgs e)
		{
			Control ctrl = (Control)sender;

			if (ctrl.Text == "")
			{
				errorProvider1.SetError(ctrl, "Player 1 must have a name.");
			}
			else if (ctrl.Text == this.tbP2Name.Text)
			{
				errorProvider1.SetError(ctrl, "Player 1 must have a unique name.");
			}
			else if (ctrl.Text.Length > 32)
			{
				errorProvider1.SetError(ctrl, "Names may have no more than 32 characters.");
			}
			else
			{
				errorProvider1.SetError(ctrl, "");
			}

			CheckErrorsForOK();
		}

		/**
		 *  Makes sure that the OK button can be pressed.
		 * */
		private void CheckErrorsForOK()
		{
			if (errorProvider1.GetError(this.tbP1Name) != "" ||
				errorProvider1.GetError(this.tbP2Name) != "" ||
				errorProvider1.GetError(this.tbServerName) != "" ||
				errorProvider1.GetError(this.tbServerPort) != "" ||
				errorProvider1.GetError(this.tbTimeLimit) != "")
			{
				this.btnOK.Enabled = false;
			}
			else
			{
				this.btnOK.Enabled = true;
			}
		}

		private void tbP2Name_TextChanged(object sender, System.EventArgs e)
		{
			Control ctrl = (Control)sender;

			if (ctrl.Text == "")
			{
				errorProvider1.SetError(ctrl, "Player 2 must have a name.");
				
			}
			else if (ctrl.Text == this.tbP1Name.Text)
			{
				errorProvider1.SetError(ctrl, "Player 2 must have a unique name.");
			}
			else if (ctrl.Text.Length > 32)
			{
				errorProvider1.SetError(ctrl, "Names may have no more than 32 characters.");
			}
			else
			{
				errorProvider1.SetError(ctrl, "");
			}

			CheckErrorsForOK();
		}

		private void tbServerName_TextChanged(object sender, System.EventArgs e)
		{
			Control ctrl = (Control)sender;

			if (ctrl.Text == "")
			{
				errorProvider1.SetError(ctrl, "The server must have a name.");
			}
			else if (ctrl.Text.Length > 128)
			{
				errorProvider1.SetError(ctrl, "The server's name must not exceed 128 characters.");
			}
			else
			{
				errorProvider1.SetError(ctrl, "");
			}

			CheckErrorsForOK();
		}

		private void tbServerPort_TextChanged(object sender, System.EventArgs e)
		{
			Control ctrl = (Control)sender;

			if (ctrl.Text == "")
			{
				errorProvider1.SetError(ctrl, "Please enter a port value.");
			}
			else
			{
				try
				{
					int val = System.Convert.ToInt32(ctrl.Text, 10);
					if (val <= 0)
					{
						errorProvider1.SetError(ctrl, "Port must be a number larger than zero.");
					}
					else if (val > 65535)
					{
						errorProvider1.SetError(ctrl, "Port must be 65535 or smaller.");
					}
					else
					{
						errorProvider1.SetError(ctrl, "");
					}
				}
				catch(Exception)
				{
					errorProvider1.SetError(ctrl, "Please enter numbers only.");
				}
			}

			CheckErrorsForOK();
		}

		private void textBox1_TextChanged(object sender, System.EventArgs e)
		{
			Control ctrl = (Control)sender;

			if(ctrl.Text == "")
			{
				errorProvider1.SetError(ctrl, "Please enter a time limit, or uncheck the checkbox.");
			}
			else
			{
				try
				{
					int val = System.Convert.ToInt32(ctrl.Text, 10);
					if (val <= 0)
					{
						errorProvider1.SetError(ctrl, "Time limit must be a number larger than zero.");
					}
					else if (val > 86400)
					{
						errorProvider1.SetError(ctrl, "Time limit must be 86400 (24 hours!) or smaller.");
					}
					else
					{
						errorProvider1.SetError(ctrl, "");
					}
				}
				catch(Exception)
				{
					errorProvider1.SetError(ctrl, "Please enter numbers only.");
				}

			}
		
			CheckErrorsForOK();
		}

		private void tbTimeLimit_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			if (!Char.IsDigit(e.KeyChar) && !Char.IsControl(e.KeyChar))
			{
				e.Handled = true;
			}
		}

		private void checkBox1_CheckedChanged(object sender, System.EventArgs e)
		{
			CheckBox ctrl = (CheckBox)sender;

			if(ctrl.Checked == true)
			{
				this.tbTimeLimit.Enabled = true;
			}
			else
			{
				this.tbTimeLimit.Enabled = false;
			}
		}
	}
}

namespace QCGM.Exceptions
{
	public class InvalidGameParameterException: ApplicationException
	{
		public InvalidGameParameterException() {}
		public InvalidGameParameterException(string message): base(message) {}
		public InvalidGameParameterException(string message, Exception inner) : base(message, inner) {}
	}
}

namespace QCGM
{
	public class NewGameSettings
	{
		public bool isPlayer1Networked = false; // is player 1 networked?
		public bool isPlayer2Networked = false; // is player 2 networked?
		public string namePlayer1 = ""; // name of player 1
		public string namePlayer2 = ""; // name of player 2
		public string serverName = ""; // human-readable name of the server
		public int serverPort = 0; // refers to the server's port
		public string hostName = ""; // hostName refers to the host's domain name
		public int timeLimit=0;
	}
}
