using System;
using Tao.Platform;
using Tao.OpenGl;
using QCGM.Geometry;


namespace QCGM.Geometry
{
	/// <summary>
	/// Contains all the data for handling a light in OpenGL
	/// </summary>
	public class Lightf
	{
		private float [] MyAmbient;
		private float [] MyDiffuse;
		private float [] MySpecular;
		private float [] MyPosition;
		private int MyLight;

		/// <summary>
		/// Initializes a blank OpenGL light.
		/// </summary>
		/// <param name="Light">The OpenGL paramter GL_LIGHTi, where i is the light to use from 1 - GL_MAX_LIGHTS.</param>
		public Lightf(int Light)
		{
			MyAmbient = new float [] {1.0f, 1.0f, 1.0f, 1.0f};
			MyLight = Light;
		}

		public float [] Ambient
		{
			get
			{
				return MyAmbient;
			}
			set
			{
				MyAmbient = value;
			}
		}

		public float [] Diffuse
		{
			get
			{
				return MyDiffuse;
			}
			set
			{
				MyDiffuse = value;
			}
		}

		public float[] Specular
		{
			get
			{
				return MySpecular;
			}
			set
			{
				MySpecular = value;
			}
		}

		public float [] Position
		{
			get
			{
				return MyPosition;
			}
			set
			{
				MyPosition = value;
			}
		}

		public int GLLight
		{
			get
			{
				return this.MyLight;
			}
			set
			{
				this.MyLight = value;
			}
		}

		/// <summary>
		/// Sets this light up for use using OpenGL commands.
		/// </summary>
		/// <param name="Light">The OpenGL paramter GL_LIGHTi, where i is the light to use from 1 - GL_MAX_LIGHTS.</param>
		public void Initialize()
		{
			Gl.glLightfv(MyLight, Gl.GL_AMBIENT, Ambient);
			Gl.glLightfv(MyLight, Gl.GL_DIFFUSE, Diffuse);
			Gl.glLightfv(MyLight, Gl.GL_SPECULAR, Specular);
			UpdatePosition();
		}

		public void UpdatePosition()
		{
			Gl.glLightfv(MyLight, Gl.GL_POSITION, Position);
		}
	}
}
