using System;
using QCGM.Geometry;

namespace QCGM
{
	public enum MouseMode { None, Dragging };

	/// <summary>
	/// Summary description for MouseControl.
	/// </summary>
	public class Mouse
	{
		public MouseButton Left = new MouseButton();
		public MouseButton Right = new MouseButton();
		public Point2Di Location;

		public bool DragLeft
		{
			get
			{
				if (Left.Pressed && Left.ClickPoint.X != this.Location.X)
				{
					return true;
				}
				else
				{
					return false;
				}
			}
		}

		public bool Clicked
		{
			get
			{
				if (Left.Pressed || Right.Pressed)
				{
					return true;
				}
				else
				{
					return false;
				}
			}
		}

		
		public Mouse()
		{
			Left = new MouseButton();
			Right = new MouseButton();
			Location = new Point2Di();
		}
	}

	public class MouseButton
	{
		public bool Pressed = false;
		public Point2Di ClickPoint = new Point2Di();

		public void Click(int x, int y)
		{
			ClickPoint.X = x;
			ClickPoint.Y = y;
			Pressed = true;
		}

		public void Release()
		{
			Pressed = false;
		}
	}
 }
