using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace QCGM.Forms
{
	/// <summary>
	/// Summary description for Preferences.
	/// </summary>
	public class PreferencesDlg : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button buttonClose;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.CheckBox checkShowSplash;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox tbListenPort;
		private System.Windows.Forms.Button buttonReset;
		private System.Windows.Forms.TextBox tbServerName;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox tbPlayer1Name;
		private System.Windows.Forms.TextBox tbPlayer2Name;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.Windows.Forms.CheckBox checkBoxTimeLimit;
		private System.Windows.Forms.TextBox tbTimeLimit;
		private System.Windows.Forms.Label label5;
		private Settings theSettings = null;

		public PreferencesDlg(Settings settings)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			theSettings = settings;

			this.tbPlayer1Name.Text = theSettings.Player1Name;
			this.tbPlayer2Name.Text = theSettings.Player2Name;
			this.tbListenPort.Text = theSettings.ServerListenPort.ToString();
			this.tbServerName.Text = theSettings.ServerName;
			this.checkShowSplash.Checked = theSettings.ShowStartupSplash;
			this.checkBoxTimeLimit.Checked = theSettings.UseTimeLimit;
			this.tbTimeLimit.Text = theSettings.TimeLimit.ToString();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.buttonClose = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.checkShowSplash = new System.Windows.Forms.CheckBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.buttonReset = new System.Windows.Forms.Button();
			this.tbListenPort = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.tbServerName = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.label3 = new System.Windows.Forms.Label();
			this.tbPlayer2Name = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.tbPlayer1Name = new System.Windows.Forms.TextBox();
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.checkBoxTimeLimit = new System.Windows.Forms.CheckBox();
			this.tbTimeLimit = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.groupBox3.SuspendLayout();
			this.SuspendLayout();
			// 
			// buttonClose
			// 
			this.buttonClose.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.buttonClose.Location = new System.Drawing.Point(320, 280);
			this.buttonClose.Name = "buttonClose";
			this.buttonClose.TabIndex = 4;
			this.buttonClose.Text = "Close";
			this.buttonClose.Click += new System.EventHandler(this.buttonClose_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.checkShowSplash);
			this.groupBox1.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox1.Location = new System.Drawing.Point(8, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(392, 48);
			this.groupBox1.TabIndex = 4;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Application Settings";
			// 
			// checkShowSplash
			// 
			this.checkShowSplash.BackColor = System.Drawing.SystemColors.Control;
			this.checkShowSplash.Checked = true;
			this.checkShowSplash.CheckState = System.Windows.Forms.CheckState.Checked;
			this.checkShowSplash.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.checkShowSplash.Location = new System.Drawing.Point(8, 16);
			this.checkShowSplash.Name = "checkShowSplash";
			this.checkShowSplash.Size = new System.Drawing.Size(176, 24);
			this.checkShowSplash.TabIndex = 0;
			this.checkShowSplash.Text = "Show splash screen on startup.";
			this.checkShowSplash.CheckedChanged += new System.EventHandler(this.checkShowSplash_CheckedChanged);
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.checkBoxTimeLimit);
			this.groupBox2.Controls.Add(this.tbTimeLimit);
			this.groupBox2.Controls.Add(this.label5);
			this.groupBox2.Controls.Add(this.buttonReset);
			this.groupBox2.Controls.Add(this.tbListenPort);
			this.groupBox2.Controls.Add(this.label2);
			this.groupBox2.Controls.Add(this.tbServerName);
			this.groupBox2.Controls.Add(this.label4);
			this.groupBox2.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox2.Location = new System.Drawing.Point(8, 64);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(392, 128);
			this.groupBox2.TabIndex = 6;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Default Server Settings";
			// 
			// buttonReset
			// 
			this.buttonReset.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.buttonReset.Location = new System.Drawing.Point(336, 16);
			this.buttonReset.Name = "buttonReset";
			this.buttonReset.Size = new System.Drawing.Size(48, 23);
			this.buttonReset.TabIndex = 8;
			this.buttonReset.Text = "Reset";
			this.buttonReset.Click += new System.EventHandler(this.buttonReset_Click);
			// 
			// tbListenPort
			// 
			this.tbListenPort.Location = new System.Drawing.Point(96, 24);
			this.tbListenPort.MaxLength = 10;
			this.tbListenPort.Name = "tbListenPort";
			this.tbListenPort.Size = new System.Drawing.Size(48, 20);
			this.tbListenPort.TabIndex = 1;
			this.tbListenPort.Text = "8167";
			this.tbListenPort.WordWrap = false;
			this.tbListenPort.TextChanged += new System.EventHandler(this.tbListenPort_TextChanged);
			// 
			// label2
			// 
			this.label2.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label2.Location = new System.Drawing.Point(8, 24);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(80, 16);
			this.label2.TabIndex = 0;
			this.label2.Text = "Listening Port:";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbServerName
			// 
			this.tbServerName.Location = new System.Drawing.Point(96, 48);
			this.tbServerName.MaxLength = 256;
			this.tbServerName.Name = "tbServerName";
			this.tbServerName.Size = new System.Drawing.Size(200, 20);
			this.tbServerName.TabIndex = 9;
			this.tbServerName.Text = "Quoridor Classic Game Server";
			this.tbServerName.TextChanged += new System.EventHandler(this.tbServerName_TextChanged);
			// 
			// label4
			// 
			this.label4.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label4.Location = new System.Drawing.Point(8, 48);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(80, 16);
			this.label4.TabIndex = 8;
			this.label4.Text = "Name:";
			this.label4.TextAlign = System.Drawing.ContentAlignment.BottomRight;
			// 
			// groupBox3
			// 
			this.groupBox3.Controls.Add(this.label3);
			this.groupBox3.Controls.Add(this.tbPlayer2Name);
			this.groupBox3.Controls.Add(this.label1);
			this.groupBox3.Controls.Add(this.tbPlayer1Name);
			this.groupBox3.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox3.Location = new System.Drawing.Point(8, 200);
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.Size = new System.Drawing.Size(392, 72);
			this.groupBox3.TabIndex = 7;
			this.groupBox3.TabStop = false;
			this.groupBox3.Text = "Default Player Profiles";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 40);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(72, 23);
			this.label3.TabIndex = 3;
			this.label3.Text = "Player 2:";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbPlayer2Name
			// 
			this.tbPlayer2Name.Location = new System.Drawing.Point(96, 40);
			this.tbPlayer2Name.Name = "tbPlayer2Name";
			this.tbPlayer2Name.Size = new System.Drawing.Size(160, 20);
			this.tbPlayer2Name.TabIndex = 2;
			this.tbPlayer2Name.Text = "Player 2";
			this.tbPlayer2Name.TextChanged += new System.EventHandler(this.tbPlayer2Name_TextChanged);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(72, 23);
			this.label1.TabIndex = 1;
			this.label1.Text = "Player 1:";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbPlayer1Name
			// 
			this.tbPlayer1Name.Location = new System.Drawing.Point(96, 16);
			this.tbPlayer1Name.Name = "tbPlayer1Name";
			this.tbPlayer1Name.Size = new System.Drawing.Size(160, 20);
			this.tbPlayer1Name.TabIndex = 0;
			this.tbPlayer1Name.Text = "Player 1";
			this.tbPlayer1Name.TextChanged += new System.EventHandler(this.textBox1_TextChanged);
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			// 
			// checkBoxTimeLimit
			// 
			this.checkBoxTimeLimit.Checked = true;
			this.checkBoxTimeLimit.CheckState = System.Windows.Forms.CheckState.Checked;
			this.checkBoxTimeLimit.Location = new System.Drawing.Point(96, 72);
			this.checkBoxTimeLimit.Name = "checkBoxTimeLimit";
			this.checkBoxTimeLimit.Size = new System.Drawing.Size(184, 24);
			this.checkBoxTimeLimit.TabIndex = 26;
			this.checkBoxTimeLimit.Text = "Use time limit (in seconds)";
			this.checkBoxTimeLimit.CheckedChanged += new System.EventHandler(this.checkBoxTimeLimit_CheckedChanged);
			// 
			// tbTimeLimit
			// 
			this.tbTimeLimit.Location = new System.Drawing.Point(96, 96);
			this.tbTimeLimit.Name = "tbTimeLimit";
			this.tbTimeLimit.Size = new System.Drawing.Size(64, 20);
			this.tbTimeLimit.TabIndex = 25;
			this.tbTimeLimit.Text = "120";
			this.tbTimeLimit.TextChanged += new System.EventHandler(this.tbTimeLimit_TextChanged);
			// 
			// label5
			// 
			this.label5.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label5.Location = new System.Drawing.Point(8, 72);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(80, 16);
			this.label5.TabIndex = 24;
			this.label5.Text = "Time Limit:";
			this.label5.TextAlign = System.Drawing.ContentAlignment.BottomRight;
			// 
			// PreferencesDlg
			// 
			this.AcceptButton = this.buttonClose;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.Control;
			this.ClientSize = new System.Drawing.Size(410, 312);
			this.Controls.Add(this.groupBox3);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.buttonClose);
			this.Controls.Add(this.groupBox1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "PreferencesDlg";
			this.ShowInTaskbar = false;
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Preferences";
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.groupBox3.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void buttonClose_Click(object sender, System.EventArgs e)
		{
			theSettings.Player1Name = this.tbPlayer1Name.Text;
			theSettings.Player2Name = this.tbPlayer2Name.Text;
			theSettings.ServerListenPort = System.Convert.ToInt32(this.tbListenPort.Text, 10);
			theSettings.ServerName = this.tbServerName.Text;
			theSettings.ShowStartupSplash = this.checkShowSplash.Checked;
			theSettings.UseTimeLimit = this.checkBoxTimeLimit.Checked;
			theSettings.TimeLimit = System.Convert.ToInt32(this.tbTimeLimit.Text, 10);

			theSettings.SaveAs(QCGM.Text.SettingsFile);
			this.Close();
		}

		private void checkShowSplash_CheckedChanged(object sender, System.EventArgs e)
		{
			this.theSettings.ShowStartupSplash = this.checkShowSplash.Checked;
		}

		private void buttonReset_Click(object sender, System.EventArgs e)
		{
			this.tbListenPort.Text = "" + Settings.DefaultServerPort;
			this.tbServerName.Text = Settings.DefaultServerName;

			this.theSettings.ServerName = Settings.DefaultServerName;
			this.theSettings.ServerListenPort = Settings.DefaultServerPort;
		}

		private void textBox1_TextChanged(object sender, System.EventArgs e)
		{
			Control ctrl = (Control)sender;

			if (ctrl.Text == "")
			{
				errorProvider1.SetError(ctrl, "Please enter a default name for player 1.");
			}
			else if (ctrl.Text == this.tbPlayer2Name.Text)
			{
				errorProvider1.SetError(ctrl, "Player 1's name must be different than player 2.");
			}
			else if (ctrl.Text.Length > 32)
			{
				errorProvider1.SetError(ctrl, "Names may have no more than 32 characters.");
			}
			else
			{
				errorProvider1.SetError(ctrl, "");
			}

			CheckErrorsForOK();
		}

		private void tbListenPort_TextChanged(object sender, System.EventArgs e)
		{
			Control ctrl = (Control)sender;

			if (ctrl.Text == "")
			{
				errorProvider1.SetError(ctrl, "Please enter a port value.");
			}
			else
			{
				try
				{
					int val = System.Convert.ToInt32(ctrl.Text, 10);
					if (val <= 0)
					{
						errorProvider1.SetError(ctrl, "Port must be a number larger than zero.");
					}
					else if (val > 65535)
					{
						errorProvider1.SetError(ctrl, "Port must be 65535 or smaller.");
					}
					else
					{
						errorProvider1.SetError(ctrl, "");
					}
				}
				catch(Exception)
				{
					errorProvider1.SetError(ctrl, "Please enter numbers only.");
				}
			}

			CheckErrorsForOK();
		}

		private void tbServerName_TextChanged(object sender, System.EventArgs e)
		{
			Control ctrl = (Control)sender;

			if (ctrl.Text == "")
			{
				errorProvider1.SetError(ctrl, "The server must have a name.");
			}
			else if (ctrl.Text.Length > 128)
			{
				errorProvider1.SetError(ctrl, "The server's name must not exceed 128 characters.");
			}
			else
			{
				errorProvider1.SetError(ctrl, "");
			}

			CheckErrorsForOK();
		}

		private void tbPlayer2Name_TextChanged(object sender, System.EventArgs e)
		{
			Control ctrl = (Control)sender;

			if (ctrl.Text == "")
			{
				errorProvider1.SetError(ctrl, "Please enter a default name for player 2.");
				
			}
			else if (ctrl.Text == this.tbPlayer1Name.Text)
			{
				errorProvider1.SetError(ctrl, "Player 2's name must be different than player 1.");
			}
			else if (ctrl.Text.Length > 32)
			{
				errorProvider1.SetError(ctrl, "Names may have no more than 32 characters.");
			}
			else
			{
				errorProvider1.SetError(ctrl, "");
			}

			CheckErrorsForOK();

		}

		private void CheckErrorsForOK()
		{
			if (errorProvider1.GetError(this.tbPlayer1Name) != "" ||
				errorProvider1.GetError(this.tbPlayer2Name) != "" ||
				errorProvider1.GetError(this.tbServerName) != "" ||
				errorProvider1.GetError(this.tbListenPort) != "" ||
				errorProvider1.GetError(this.tbTimeLimit) != "")
			{
				this.buttonClose.Enabled = false;
			}
			else
			{
				this.buttonClose.Enabled = true;
			}
		}

		private void checkBoxTimeLimit_CheckedChanged(object sender, System.EventArgs e)
		{

		}

		private void tbTimeLimit_TextChanged(object sender, System.EventArgs e)
		{
			Control ctrl = (Control)sender;

			if(ctrl.Text == "")
			{
				errorProvider1.SetError(ctrl, "Please enter a time limit, or uncheck the checkbox.");
			}
			else
			{
				try
				{
					int val = System.Convert.ToInt32(ctrl.Text, 10);
					if (val <= 0)
					{
						errorProvider1.SetError(ctrl, "Time limit must be a number larger than zero.");
					}
					else if (val > 86400)
					{
						errorProvider1.SetError(ctrl, "Time limit must be 86400 (24 hours!) or smaller.");
					}
					else
					{
						errorProvider1.SetError(ctrl, "");
					}
				}
				catch(Exception)
				{
					errorProvider1.SetError(ctrl, "Please enter numbers only.");
				}
			}
		
			CheckErrorsForOK();
		}
	}
}
