using System;
using QCGM.Boards;
using QCGM.Geometry;
using Tao.Platform;
using Tao.OpenGl;

namespace QCGM.Boards
{
	/// <summary>
	/// This class 
	/// </summary>
	public class Tile : IDrawable
	{
		protected PlayerContents MyPlayer = PlayerContents.Empty;	// Whether a player occupies this tile
		//protected WallContents MyWalls = WallContents.Empty;		// Whether there are any walls adjacent to this tile
		protected Color4f MyColor = new Color4f();					// The color of the tile
		
		protected Point3Df MyPosition = new Point3Df();				// The position of the object (in world coordinates)
		protected Point3Df MyDimension = new Point3Df();			// The dimensions of the object (in world coordinates)

		protected int myX=0; // The x position of this tile on the game board.
		protected int myY=0; // The y position of this tile on the game board.

		protected bool right = false;
		protected bool up = false;

		private bool annexUp=false;
		public bool AnnexUp // is the "up" wall an "attachment"? Or is it the start of a new wall?
		{
			get
			{
				return annexUp;
			}
			set
			{
				annexUp=value;
			}
		}

		private bool annexRight=false;
		public bool AnnexRight
		{
			get
			{
				return annexRight;
			}
			set
			{
				annexRight = value;
			}
		}

		public bool WallRight
		{
			get
			{
				return right;
			}
			set
			{
				right = value;
			}
		}

		public bool WallUp
		{
			get
			{
				return up;
			}
			set
			{
				up = value;
			}
		}

		/// <summary>
		/// The X position of this tile on the game board
		/// </summary>
		public int X
		{
			get
			{
				return myX;
			}
		}

		/// <summary>
		/// The Y position of this tile on the game board
		/// </summary>
		public int Y
		{
			get
			{
				return myY;
			}
		}

		/// <summary>
		/// Creates an empty Tile. All data members are initialized to zero. You must call property accessors to
		/// properly initialize the class.
		/// </summary>
		public Tile(int x, int y, Point3Df Position, Point3Df Dimension)
		{
			MyPosition = Position;
			MyDimension = Dimension;
			myX = x;
			myY = y;

			this.MyColor = Colors.Tiles;
		}

		public override int GetHashCode() 
		{
			return this.myX ^ this.myY;
		}

		/// <summary>
		/// Gets and sets the color value for this Tile.
		/// </summary>
		public Color4f Color
		{
			get
			{
				return MyColor;
			}

			set
			{
				updateMe = true;
				MyColor = value;
			}
		}

		private bool updateMe=false;
		public bool UpdateMe
		{
			get
			{
				return updateMe;
			}
			set
			{
				updateMe = value;
			}
		}


			/// <summary>
			/// Gets and sets the player that occupies this Tile.
			/// </summary>
			public PlayerContents Player
		{
			get
			{
				return MyPlayer;
			}
			set
			{
				MyPlayer = value;
			}
		}

		/// <summary>
		/// Draws this Tile according to its member parameters using OpenGL.
		/// </summary>
		public void Draw()
		{
			int i = Geometry.Namestack.al.IndexOf(this);

			Gl.glPushName(i);

			Colors.SetGlColor(MyColor);
			Shapes.DrawCube(MyPosition, MyDimension);

			Gl.glPopName();
		}
	}
}