using System;
using QCGM.Graphs2;
using QCGM.Boards;
//using QCGM.Graphs.Dijkstras;



namespace QCGM.Graphs2
{
	/// <summary>
	/// Summary description for Node2.
	/// </summary>
	public class Node2
	{
		public const int NUP = 0; // Neighbor up
		public const int NDOWN = 1; // Neighbor down
		public const int NLEFT = 2; // Neighbor left
		public const int NRIGHT = 3; // Neighbor right
		public const int Infinity = 20000;

		private Tile tile;

		Node2 [] neighbors = new Node2[4];
		int [] cost = new int[4];

		public Node2(Tile t)
		{
			this.tile = t;
			for(int i=0; i < 4; i++)
			{
				this.cost[i] = 20000;
				this.neighbors[i] = null;
			}
		}

		public Node2 Copy()
		{
			Node2 n = new Node2(this.Tile);
			n.neighbors = this.neighbors;
			n.cost = this.cost;
			n.dijkstra_d = this.dijkstra_d;
			n.dijkstra_Pi = this.dijkstra_Pi;
			return n;
		}

		public Tile Tile
		{
			get
			{
				return this.tile;
			}
		}

		public void SetNeighbors(Node2 [] neighbors)
		{
			this.neighbors = neighbors;
		}

		public void SetNeighbor(int index, Node2 neighbor, int cost)
		{
			if (index >= 0 && index < 4 && cost >= 0)
			{
				this.neighbors[index] = neighbor;
				this.cost[index] = cost;
			}
			else
			{
				throw new Exception("Barf!!!!!");
			}
		}


		public void RemoveNeighbor(int index)
		{
			if(index >= 0 && index < 4)
			{
				this.neighbors[index] = null;
				this.cost[index] = Infinity;
			}
		}

		public bool visited = false;

		public void UpdateCost(int index, int cost)
		{
			if(index >= 0 && index < 4 && cost >= 0)
			{
				this.cost[index] = cost;
			}
			else
			{
				throw new Exception("NOOOOO!!");
			}
		}

		public Node2 [] Neighbors
		{
			get
			{
				return this.neighbors;
			}
		}

		public int [] Cost
		{
			get
			{
				return this.cost;
			}
		}

		private int dijkstra_d=0;
		public int Dijkstra_d
		{
			set
			{
				dijkstra_d = value;
			}
			get
			{
				return dijkstra_d;
			}
		}

		private Node2 dijkstra_Pi = null;
		public Node2 Dijkstra_Pi
		{
			get
			{
				return dijkstra_Pi;
			}

			set
			{
				dijkstra_Pi = value;
			}
		}	

		private BFSColors bfs_color;
		public BFSColors BFS_Color
		{
			get
			{
				return bfs_color;
			}
			set
			{
				bfs_color = value;
			}
		}

		private int bfs_d;
		public int BFS_d
		{
			get
			{
				return bfs_d;
			}
			set
			{
				bfs_d = value;
			}
		}

		private Node2 bfs_Pi=null;
		public Node2 BFS_Pi
		{
			get
			{
				return bfs_Pi;
			}
			set
			{
				bfs_Pi = value;
			}
		}

		private int bfs_F=0;
		public int BFS_F
		{
			get
			{
				return bfs_F;
			}
			set
			{
				bfs_F = value;
			}
		}

	}
}
