package A_R_T;

use Exporter;
@ISA = ('Exporter');
@EXPORT = qw( 	&read_message 
				&evaluate_priority 
				&get_config
				&create_multicast_objects 
				&send_multicast_broadcast);

use lib '/opt/scripts/shared';
use common_functions;
use IO::Socket::Multicast;
use IO::Select;
use POSIX;
use Mail::Sendmail;

my $CONFIG = "";
my $APP_NAME = "";
my $MCAST_GRP = "";
my $MCAST_PORT = "";
my $PRIORITY = 0;
my $STATE = "";
my $ALLOWABLE_MISSED_POLLS = "";
my $B_CAST_IVAL = "";
my $HOST = "";

my $destination = "";
my $multicast_sender;
my $multicast_broadcast = "";
my $multicast_receiver;

my $message_application_name = "";
my $message_multicast_group = "";
my $message_multicast_port = "";
my $message_priority = 0;
my $message_state = "";
my $message_missed_polls = "";
my $message_broadcast_interval = "";

my $is_application_present = 0;
my @MULTICAST_MESSAGES;
my $missed_polls = 0;
my $each_message = "";
my $count_sending = 0;
my $WATCHED_SOCKETS = new IO::Select();
my $count_sending_message = 0;
my $msg_time_stamp = 0;
my $time_stamp = 0;
my ($HOUR,$DAY,$MONTH,$YEAR);
my $numReady = scalar(@readySockets);
my $activeSocket;
my $end_of_message = '^';
my $current = 0;

my $monitor_database_host = 'spiderfish1.operations.gci.com';
my $monitor_database = 'art_monitor_db';
my $monitor_tab = 'status_tab';
my $host_uid = 'root';
my $host_password = '8GigotoS*';
my $db_handle = "";
my $SQL = "";
my $STH = "";
my $db_error = "";

#*********************************************************
#**	Subroutine: send_email()
#**	Purpose: send email notification if there are problems.                           
#** 	Parameters: $subject
#**	Written by: Kristi Olson
#**	Date:	6/7/2005
#**
#*********************************************************
sub send_email {
my $TYPE = shift;
my $MISC1 = shift;
my $MISC2 = shift;
my $MISC3 = shift;

my %MAIL;
$MAIL{"To"} = 'kolson@gci.com';
$MAIL{"From"} = 'traffic_30_multicast@gci.com';
$MAIL{"Subject"} = 'Notification from Traffic 30 Multicast';

($HOURS,$DAY,$MONTH,$YEAR) = (localtime)[2,3,4,5];
    $YEAR = $YEAR + 1900;
    $MONTH = $MONTH + 1;
    my $alert_time = sprintf("%02d-%02d-%04d-%02d",$MONTH,$DAY,$YEAR,$HOURS);


my $MSG = "";

if ($TYPE eq 'PASSIVE_NOW_ONLINE') {
	$MSG = "Passive version of $APP_NAME has come online at $alert_time.";
}

elsif ($TYPE eq 'MASTER_NOW_ONLINE') {
	$MSG = "Master version of $APP_NAME has come online at $alert_time.";
}

else {
	$MSG = "Unknown error occured with the Traffic 30 Multicast";
	}

$MAIL{"Message"} = $MSG;
sendmail(%MAIL) or die $Mail::Sendmail::error;
return;
} #end send_email

#*********************************************************
#**	Subroutine: connect_to_database()
#**	Purpose: connect to a database.                           
#** Parameters: no parameters
#**	Written by: Kristi Olson
#**	Date:	7/21/2005
#**
#*********************************************************
sub connect_to_database{ 
	#**													   **
	#**  Establish a connection with the database server.  **
	#**													   **
	$db_handle = DBI -> connect(
				"DBI:mysql:$monitor_database:$monitor_database_host",
				$host_uid,
				$host_password,
				{ PrintError => 1,
				  RaiseError => 0 }
	);

	if (!defined $db_handle) {
		$db_error = $DBI::errstr;
		send_email 'DATABASE_CONNECTION_ERROR', $monitor_database, $monitor_database_host, $db_error;
		die "\n\nUnable to establish a connection with the database server.\n\n";

	} else {
		print "\n\nConnected to the database $monitor_database.\n";

	}	# end if
} #end sub connect_to_database


#*********************************************************
#**	Subroutine: disconnectFromDatabase()
#**	Purpose: connect to a MySQL database.                           
#** 	Parameters: $DB_NAME and $DB_HOST.
#**	Written by: Kristi Olson
#**	Date:	5/26/2005
#**
#*********************************************************
sub disconnectFromDatabase{ 

	my $database_to_disco = shift;
	my $database_to_disco_host = shift;
	my $db_handle = shift;
	
	if ($db_handle -> disconnect()) {
		print "disconnecting from $database_to_disco on $database_to_disco_host\n";
		}
	else {
		print "problem disconnecting from $database_to_disco on $database_to_disco_host\n";
		}

} #end sub disconnectFromDatabase

#######################################################
# Name: get_config
# Purpose: take in name of config file and get 
# necessary parameters.
#
# Written by: Kristi Olson
# Date: 5/28/2005
# 
#######################################################
sub get_config {
$CONFIG = shift;
$APP_NAME = ReadConfLine $CONFIG, "Application Name";
$MCAST_GRP = ReadConfLine $CONFIG, "Multicast Group";
$MCAST_PORT = ReadConfLine $CONFIG, "Multicast Port";
$PRIORITY = ReadConfLine $CONFIG, "Priority";
$STATE = ReadConfLine $CONFIG, "State";
$ALLOWABLE_MISSED_POLLS = ReadConfLine $CONFIG, "Missed Poll Counter";
$B_CAST_IVAL = ReadConfLine $CONFIG, "Broadcast Interval";
$HOST = ReadConfLine $CONFIG, "Host";

return $B_CAST_IVAL;
} #end sub get_config

#######################################################
# Name: create_multicast_objects
# Purpose: create a multicast objects for sending and
# receving messages.
# Written by: Kristi Olson
# Date: 5/28/2005
# 
#######################################################

sub create_multicast_objects {
$destination = $MCAST_GRP .':' . $MCAST_PORT;
$multicast_sender = IO::Socket::Multicast->new(Proto=>'udp',PeerAddr=>$destination,ReuseArrr=>1);

$multicast_receiver = IO::Socket::Multicast->new(LocalPort =>$MCAST_PORT, ReuseAddr=>1);
$multicast_receiver->mcast_add($MCAST_GRP)|| die "Couldn't set group: $!\n";

$WATCHED_SOCKETS->add($multicast_receiver);
$WATCHED_SOCKETS->add($multicast_sender);
$multicast_receiver -> mcast_ttl(32);
$multicast_sender -> mcast_ttl(32);

} #end create_multicast_objects



#######################################################
# Name: send_multicast_broadcast
# Purpose: Create a message containing the application's name, 
# priority, and timestamp. Send the message.
#
# Written by: Kristi Olson
# Date: 5/28/2005
# 
#######################################################
sub send_multicast_broadcast {
	$count_sending++;
	$time_stamp = time;
	$multicast_broadcast = "$APP_NAME $PRIORITY $count_sending $time_stamp $end_of_message";
	if ($multicast_sender->send($multicast_broadcast, $destination)) {	
		
#		print "****SENDING msg# $count_sending FROM $APP_NAME TO $destination at time $time_stamp\n";
	
	}
} #end send_multicast_broadcast


#######################################################
# Name: receive_multicast_messages
# Purpose: Receive multicast messages.
# Note this is written in a "do until" style. Each time the method
# is called, read any waiting messages. If there are no messages to 
# be read, return to the caller. If there are messages to read, enter
# the while loop which will continue reading messages until a current
# one is read. Current messages get pushed onto the message array
# and old messages are skipped over. 
#
# Written by: Kristi Olson
# Date: 5/28/2005
# 
#######################################################
sub receive_multicast_messages {
	
	# read any waiting messages. If there are none to read, 
	# return to caller.
	do {
		@readySockets = $WATCHED_SOCKETS -> can_read(1);
		my $numReady = scalar(@readySockets);
		if ($numReady == 0) {
			
			return;
			
		}
		
		# while there are old messages to be skipped over, 
		# keep reading messages until a current one is found.
		while ($current == 0) {			
			@readySockets = $WATCHED_SOCKETS -> can_read(1);
			
   			foreach $activeSocket (@readySockets) {
   				
    			if ($multicast_receiver->recv($data,128)) {
    				my $time_check = time;
 #   				print "***receiving data***: $data at time: $time_check\n";

    				# use Perl regex to parse out the different parts of the mcast message.
    				# $1 is the application name, $2 is the priority of the mssage, 
    				# $3 is the number of the message, and $4 is the time the message was sent.
    				my $find_time_stamp = $data;
    				$find_time_stamp =~ /([A-Z]*[a-z]*)\s+(\d*)\s+(\d*)\s+(\d*)/;   		    		
    				my $time_stamp = $4;
    		
    				# this is a current message. Push it onto the message array
    				# and break out of the while loop.
    				if (time < $time_stamp + $B_CAST_IVAL * 2) {
    					push @MULTICAST_MESSAGES, $data;
    					$current = 1;
    					return;
    			
    				}
    				else {
    					# This is an old message. Ignore it and move on.
    					$current = 0;
    				} # end inner else
    			} # end if there is a message
    		} # end foreach activeSocket
		}# end while loop
} # end of do

until ( $current = 0);


} #end receive_multicast_messages


#######################################################
# Name: read_message
# Purpose: take in a multicast message and split out the
# values for application name and priority.
#
# Written by: Kristi Olson
# Date: 5/23/2005
# 
#######################################################
sub read_message {
    my $message = shift;
    my @SPLIT_ARRAY = split/ /,$message;
    $message_application_name = $SPLIT_ARRAY[0];    
    $message_priority = $SPLIT_ARRAY[1];
    $count_sending_message = $SPLIT_ARRAY[2];
    $msg_time_stamp = $SPLIT_ARRAY[3];

}#end sub read_message


#*********************************************************
#**  Written by: Doug Huvar				**
#**  Function Name: Handler_SigQuit					**
#**							**
#*********************************************************
sub Handler_SigQuit {

    print STDERR "Received a signal to shut down.  Shutting down.\n";
    
    $GLOBAL_SHUTDOWN = $TRUE;

    $SIG{STOP} = \&Handler_SigQuit;
    $SIG{INT}  = \&Handler_SigQuit; 
    $SIG{TERM} = \&Handler_SigQuit;
    $SIG{QUIT} = \&Handler_SigQuit;
    
    #** Send out email notification of socket problems
    my $message1 = "The Traffic 30 script has received a signal to shut down.\n";
    my $message2 = "SIGPIPE (Handler_SigQuit): Received a broken pipe signal (SIGPIPE).\n";
    my $message3 = "Please investigate this problem immediately.\n";
    Send_Email_Notification ("The Traffic30 Program Is Shutting Down", $message1, $message2, $message3);
    
    return;

} #end of Handler_SigQuit

#######################################################
# Name: update_monitor
# Purpose: update the monitor database with the application's
# current status. 
# 
# Written by: Kristi Olson
# Date: 10/18/2005
# 
#######################################################
sub update_monitor {
	
	connect_to_database;
	
		#strip out '.plx' and '.conf'
		my $app_name_for_db = $APP_NAME;
		$app_name_for_db =~ s/\.plx//;	
		my $config_for_db = $CONFIG;
		$config_for_db =~ s/\.conf//;	
	
	if ($STATE eq MASTER) {
		$SQL = "UPDATE $monitor_tab SET application_status = 1, ";
		$SQL .= "timestamp = NOW() WHERE application_name = '$app_name_for_db' ";
		$SQL .= "AND application_config = '$config_for_db' AND application_host = '$HOST'";
		
		$STH = $db_handle -> prepare($SQL);
		
		if (!defined $STH) {
			$db_error = $DBI::errstr;
			send_email 'DATABASE_ERROR', $monitor_tab, $SQL, $db_error;
			print "unable to prepare statement $SQL due to $db_error\n";
		}
		$RESULT = $STH->execute();
		if (!defined $RESULT) {
			$db_error = $DBI::errstr;
			send_email 'DATABASE_ERROR', $monitor_tab, $SQL, $db_error;
			print "unable to execute statement $SQL\n";
		}
		
	} # end if $STATE eq MASTER
	
	else {
		
		$SQL = "UPDATE $monitor_tab SET application_status = 0, ";
		$SQL .= "timestamp = NOW() WHERE application_name = '$app_name_for_db' ";
		$SQL .= "AND application_config = '$config_for_db' AND application_host = '$HOST'";
		
		$STH = $db_handle -> prepare($SQL);
		
		if (!defined $STH) {
			$db_error = $DBI::errstr;
			send_email 'DATABASE_ERROR', $monitor_tab, $SQL, $db_error;
			print "unable to prepare statement $SQL due to $db_error\n";
		}
		$RESULT = $STH->execute();
		if (!defined $RESULT) {
			$db_error = $DBI::errstr;
			send_email 'DATABASE_ERROR', $monitor_tab, $SQL, $db_error;
			print "unable to execute statement $SQL\n";
		}
	}
		
	disconnectFromDatabase $monitor_database, $monitor_database_host, $db_handle;
	$STH -> finish();
	
	return;
	
} # end update_monitor
#######################################################
# Name: evaluate_priority
# Purpose: evaluate message queue. If it is empty, we are
# not receiving any messages and need to bring the hot
# standby on line. 
#
# If we are receiving messages, evaluate the message's priority
# and decide whether or not to bring the hot standby on line.
# The application with the highest priority becomes the active
# master.
#
# Written by: Kristi Olson
# Date: 5/23/2005
# 
#######################################################

sub evaluate_priority {
	
	receive_multicast_messages;
	
	$is_application_present = 0;
	if ($STATE eq MASTER) {
		send_multicast_broadcast;
	}
	
	foreach $each_message (@MULTICAST_MESSAGES) { 
  		my $count = scalar(@MULTICAST_MESSAGES);
 		read_message $each_message;
        
      	if (($APP_NAME eq $message_application_name) & ($PRIORITY == $message_priority) & ($STATE eq MASTER)) {
      			
        	#This application is receiving its own messages. 
        	#There is no need to process this message.
        	$is_application_present = 1;
        	$missed_polls = 0;
        	last;
        }
        
		#check to see if there are messages we need to process.
      	elsif (($APP_NAME eq $message_application_name) & (! ($PRIORITY == $message_priority))) {
      			
        	if ($PRIORITY < $message_priority) {
              	$STATE = PASSIVE;
           		$is_application_present = 1;
           		$missed_polls = 0;
        	}

			elsif ($PRIORITY > $message_priority) {
				# If $is_application_present is 0, this falls into the 
						
			} #end of checking for higher priority.
					
			else {
				# we have received an erroneous message.
				print "we have received an erroneous message for this application:$message_application_name priority: $message_priority\n";
			}
					
		} #end of elsif there are messages to process.
 	}#end foreach message
					
	if (($is_application_present == 0) && ($STATE ne MASTER)){
		$missed_polls++;
		if ($missed_polls > $ALLOWABLE_MISSED_POLLS) {
			$STATE = MASTER;
			$is_application_present = 1;
			$missed_polls = 0;
		} #end if allowable missed polls exceeded.
	}
			
	#######################################################
	# 	erase messages in message queue so you don't respond
	#   to the same messages again.	
	@MULTICAST_MESSAGES = ();
	update_monitor;
	return $STATE;

} #end evaluate_priority
1;
