package mosaiccreator;

import java.io.File;
import javax.swing.filechooser.FileFilter;

/**
 *
 * <p>Title: Mosaic Filter </p>
 * <p>Description: filters out all file accept the .mosaic files </p>
 * @author Lance Finfrock
 * @version 1.0
 */
public class MosaicFilter extends FileFilter {

  /**
   * checks if the file is a .mosaic file
   * @param f File file to be checked
   * @return boolean if the file is a .mosaic
   */
  public boolean accept(File f) {

    String FileName = f.getName();

    if (f.isDirectory() || FileName.endsWith(".mosaic")) {
      return true;
    }
    else
      return false;
  }

  /**
   *
   * @return String the file description
   */
  public String getDescription() {
    return "Mosaic files";
  }

}
