package mosaiccreator;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.MediaTracker;
import java.awt.Component;
import java.io.File;
import javax.swing.JFrame;
import java.awt.image.BufferedImage;
import java.awt.Graphics;

/**
 *
 * <p>Title: Picture Tools</p>
 * <p>Description: used to read in images</p>
 * @author Lance Finfrock
 * @version 1.0
 */
public class PictureTools {

  //used if the method does not pass in a window
  private static JFrame defautComponent = new JFrame();

  /**
   *  reads in an image and stritched it to width and height
   * @param imageName String the path to the image
   * @param width int the width the image is stritched
   * @param height int the height the image is stritched
   * @param component Component the window came from
   * @return Image the image created
   */
  public static Image readImage(String imageName, int width, int height, Component component) {
    Image image = null;

    File imageFile = new File(imageName);

    //check if the path is a file
    if(imageFile.isFile()){
      try {

          //read in the image stritched
          image = Toolkit.getDefaultToolkit().getImage(imageName).
              getScaledInstance(
              width, height, Image.SCALE_FAST);


        MediaTracker imageTracker;

        //if on window is passed in
        if( component == null) {
          imageTracker = new MediaTracker(defautComponent);
        }
        else {
          imageTracker = new MediaTracker(component);
        }

        imageTracker.addImage(image, 0);

        imageTracker.waitForID(0);

      }
      catch (Exception e) {
        System.err.println("error reading in image file");
        return null;
      }
      return image;
    }
    else{//if the path is not a file

      //create a image that says that the image was not found
      BufferedImage picturePiece = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
      Graphics g = picturePiece.getGraphics();
      String largeDisplayString = "Picture Not Found";
      String smallDisplayString = "Not Found";
      int charPixelSize = 3;
      if(width >= largeDisplayString.length()* 4){
        g.drawString(largeDisplayString,
                     width / 2 - (largeDisplayString.length() * charPixelSize),
                     height / 2 + 5);
      }
      else if(width >= smallDisplayString.length() * 4){
        g.drawString(smallDisplayString,
                     width / 2 - (smallDisplayString.length() * charPixelSize),
                     height / 2 + 5);
      }

      return picturePiece;
    }
  }

  /**
   * reads in an image
   * @param imageName String the path to the image
   * @param component Component window the that called this method
   * @return Image the image created
   */
  public static Image readImage(String imageName, Component component) {

    //the image name is a file
    if((new File(imageName)).isFile()){

      Image image = null;

      try {
        image = Toolkit.getDefaultToolkit().getImage(imageName);
        MediaTracker imageTracker;

        if (component == null){
          imageTracker = new MediaTracker(defautComponent);
        }
        else {
          imageTracker = new MediaTracker(component);
        }

        imageTracker.addImage(image, 0);

        imageTracker.waitForID(0);
      }
      catch (Exception e) {
        return null;
      }

      return image;

    }
    else{//if the path is not a file

      //create a image that says that the image was not found
      int charPixelSize = 3;
      String displayString = "Picture Not Fount At";
      BufferedImage picturePiece = new BufferedImage((imageName.length() * 6) + 50, 100, BufferedImage.TYPE_INT_RGB);
      Graphics g = picturePiece.getGraphics();

      g.drawString(displayString, picturePiece.getWidth()/2 -(displayString.length()*charPixelSize), 40);
      g.drawString(imageName,25, 60 );

      return picturePiece;
    }
  }
}
