package mosaiccreator;

import javax.swing.JPanel;
import java.awt.Color;
import java.awt.Image;
import java.awt.Graphics;

/**
 * <p>Title: Sample Viewer </p>
 * <p>Description: displays an image with divisions </p>
 * @author Lance Finfrock
 * @version 1.0
 */
public class SampleView extends JPanel {

  /**
   * the image to be displayed
   */
  private Image image;

  /**
   * the width divisions what will be drawn on the image
   */
  private int divisionsWidth;

  /**
   * the height divisions what will be drawn on the image
   */
  private int divisionsHeight;

  /**
   * @param divWidth int the width divisions that will be drawn on the image
   * @param divHeight int the height divisions that will be drawn on the image
   */
  public SampleView(int divWidth, int divHeight) {
    this.divisionsWidth = divWidth;
    this.divisionsHeight = divHeight;

    //showing the panel
    this.setVisible(true);

  }
  /**
   * change the divisions and redraw
   * @param divWidth int
   * @param divHeight int
   */
  public void setDivisions(int divWidth, int divHeight){

    this.divisionsWidth = divWidth;
    this.divisionsHeight = divHeight;
    this.repaint();

  }

  /**
   * change the image that is displayed
   * @param pic String the path to the new image change to
   */
  public void setPicture(String pic) {

    int ScaledWidth, ScaledHeight;

    //create the image
    this.image = PictureTools.readImage(pic, this);

    //find the max size of the display image
    if (this.image.getHeight(this) > this.image.getWidth(this)) {
      ScaledHeight = this.getHeight();
      ScaledWidth = (this.image.getWidth(this) * ScaledHeight) / this.image.getHeight(this);
    }
    else {
      ScaledWidth = this.getWidth();
      ScaledHeight = (this.image.getHeight(this) * ScaledWidth) / this.image.getWidth(this);
    }

    //resize the image
    this.image = PictureTools.readImage(pic, ScaledWidth, ScaledHeight, this);

    //display the new image
    this.repaint();
  }

  public void paint(Graphics g) {

    //clear the window
    g.setColor(new Color(245,245,245));
    g.drawRect(0, 0, this.getWidth(), this.getHeight());

    //the image is readed in completly
    if(this.image != null && this.image.getWidth(this) != -1 ){

      //display the image
      g.drawImage(this.image, this.getWidth() / 2 - image.getWidth(this) / 2,
                  this.getHeight() / 2 - image.getHeight(this) / 2, null);

      //draw the division on the image
      int w, h, linewidth, lineheight;

      //set the color to gray
      g.setColor(new Color(70, 70, 70));


      w = 0;
      h = 0;
      linewidth = this.image.getWidth(this) / divisionsWidth;
      lineheight = this.image.getHeight(this) / divisionsHeight;

      //drawing the height lines
      for (int i = 0; i <= divisionsHeight; i++) {
        h = i * lineheight;
        g.drawLine(w + (this.getWidth() / 2 - this.image.getWidth(this) / 2),
                   h + (this.getHeight() / 2 - this.image.getHeight(this) / 2),
                   w + (this.getWidth() / 2 - this.image.getWidth(this) / 2) +
                   this.image.getWidth(this) - 1,
                   h + (this.getHeight() / 2 - this.image.getHeight(this) / 2));
      }
      h = 0;

      //drawing the width lines
      for (int i = 0; i <= this.divisionsWidth; i++) {
        w = i * linewidth;
        g.drawLine(w + (this.getWidth() / 2 - this.image.getWidth(this) / 2),
                   h + (this.getHeight() / 2 - this.image.getHeight(this) / 2),
                   w + (this.getWidth() / 2 - this.image.getWidth(this) / 2),
                   h + this.image.getHeight(this) - 1 +
                   (this.getHeight() / 2 - this.image.getHeight(this) / 2));
      }
    }
    else{//the image was not read in
      g.drawString("No Picture", this.getWidth()/2 - 40, this.getHeight()/2);
    }

  }


}
