package mosaiccreator;

import javax.swing.JFrame;
import java.awt.Image;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Graphics;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.ComponentEvent;

/**
 *
 * <p>Title: Picture Viewer </p>
 * <p>Description: window to view one image </p>
 * @author Lance Finfrock
 * @version 1.0
 */
public class pictureViewer extends JFrame {

  /**
   * the full size image
   */
  private Image OriginalImage;

  /**
   * the resize image for the window
   */
  private Image displayedImage;

  /**
   * the width of the left and right white space
   */
  private int borderWidth;

  /**
   * the height of the top and bottom
   */
  private int borderHeight;

  /**
   * the directory path to the image diplayed
   */
  private String ImagePath;

  /**
   *
   * @param imagePath String the path to the image
   */
  public pictureViewer(String imagePath) {

    // a listener to catch resizes to the window
    this.addComponentListener(new resizeListener());

    this.ImagePath = imagePath;

    //create the original image
    this.OriginalImage = PictureTools.readImage(ImagePath, this);

    // the image is not found exit this window
    if(this.OriginalImage == null)this.dispose();


    this.setTitle(imagePath);

    //set the back ground to white
    this.setBackground(Color.WHITE);

    //get the current screen size
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    //create the window one third the size of the current screen size
    int width = (int) screenSize.getWidth() / 3;
    int height = (int) screenSize.getHeight() / 3;
    this.setSize(width, height);


    this.validate();

    //Center the window
    Dimension frameSize = this.getSize();
    if (frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    this.setLocation( (screenSize.width - frameSize.width) / 2,
                     (screenSize.height - frameSize.height) / 2);

    //show the window
    this.setVisible(true);
  }

  /**
   * clear the window and draw the image to the screen
   * @param g Graphics the graph to the screen
   */
  public void paint(Graphics g) {

    //clear the window
    g.clearRect(0, 0, this.getWidth(), this.getHeight());

    //draw the image
    g.drawImage(this.displayedImage, this.borderWidth, this.borderHeight + 30, null);

  }

  /**
   * finds the greatest diemntions for the image in this window
   */
  private void findPictureWidthHeight() {

      //width of this window
      int windowWide = this.getWidth();

      //height of this window minus the toolbar
      int windowHeight = this.getHeight()- 30;

      int PictureHeight, PictureWidth;

      //the image is smaller than the window size
      if(this.OriginalImage.getWidth(null) < windowWide && this.OriginalImage.getHeight(null) < windowHeight){
        this.displayedImage = PictureTools.readImage(ImagePath, this);
        return;
      }
      //the image is larger then the window size
      else if ( ( (double)this.OriginalImage.getWidth(null)) / this.OriginalImage.getHeight(null) >
          ( (double) windowWide) / windowHeight) {
        PictureWidth = windowWide;
        PictureHeight = (this.OriginalImage.getHeight(null) * PictureWidth) / this.OriginalImage.getWidth(null);
      }
      else {
        PictureHeight = windowHeight;
        PictureWidth = (this.OriginalImage.getWidth(null) * PictureHeight) / this.OriginalImage.getHeight(null);
      }

      //create the resized image
      this.displayedImage = PictureTools.readImage(ImagePath, PictureWidth, PictureHeight, this);

    }



    /**
     * resizes the image and redisplays it to the screen
     */
    private void resize() {

      //find the max dimentions for the image in this window
      this.findPictureWidthHeight();

      //find the height to center the image in the window
      this.borderHeight = ( (this.getHeight() - 30) - displayedImage.getHeight(null)) /
          2;

      //find the width to center the image in the window
      this.borderWidth = (this.getWidth() - displayedImage.getWidth(null)) / 2;

    }

  //Overridden so we can not exit when window is closed
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);

    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      this.dispose();
    }
  }

  /**
   *
   * <p>Title: Resize Listener</p>
   * <p>Description: catches the resize event on the window</p>
   * @author Lance Finfrock
   * @version 1.0
   */
  private class resizeListener implements ComponentListener {

    /**
     * fires when the window is resized
     * @param componentEvent ComponentEvent
     */
    public void componentResized(ComponentEvent componentEvent) {
      resize();
    }

    public void componentMoved(ComponentEvent componentEvent) {}
    public void componentShown(ComponentEvent componentEvent) {}
    public void componentHidden(ComponentEvent componentEvent) {}

  }

}
