<?php
// Session.php

/**
 * This class holds Member session data.  
 *
 * @author Matthew Lindberg
 */
class Session
{
	// Session variables
	var $_sess_vars;
	
	
	
	
	/**
	 * Constructor.
	 * 
	 * @access public
	 */
	function Session()
	{
		// Start a new php session
		session_start();
		
		$this->_sess_vars = array();
		
		// Set all of the current $_SESSION variables to this object
		foreach( $_SESSION as $key	=>	$value ) {
			$this->_sess_vars[$key] = $value;
		}
	}
	
	/**
	 * Checks whether a session variable is set.
	 *
	 * @param $key string
	 * @access public
	 */
	function isKeySet( $key )
	{
		return isset($_SESSION[$key]);
	}
	
	/**
	 * Destroys a current session key.
	 *
	 * @param $key string
	 * @access public
	 */
	function destroyKey( $key )
	{
		if( isset($_SESSION[$key]) ) {
			session_unregister( $key );
		}
	}
	
	/** 
	 * Gets the value of a session variable.
	 *
	 * @param $key string
	 * @access public
	 */
	function getValue( $key )
	{
		if( !$this->isKeySet( $key ) ) {
			return false;
		} else {
			return $this->_sess_vars[$key];
		}
	}
	
	/**
	 * Sets a session variable to a new value.
	 *
	 * @param $key string
	 * @param $value
	 * @access public
	 */
	function setValue( $key, $value ) 
	{
		$_SESSION[$key] = $value;
		$this->_sess_vars[$key] = $_SESSION[$key];
	}
	
	/**
	 * Registers a new session variable.
	 *
	 * @param $key string
	 * @access public
	 */
	function register($key)
	{
		if( !$this->isKeySet( $key ) ) {	
			session_register($key);
		}
	}
	
	/**
	 * Destroys the current session.
	 *
	 * @access pubilc
	 */
	function destroySession()
	{
		session_destroy();
	} 
}
?>