<?php
//ActionChain.php

/**
 * A sequence of actions that are executed until the end of the chain is reached,
 * or an action failure is encountered.
 *
 * @author Matthew Lindberg
 */
class ActionChain
{
	// chain of actions
	var $actions;
	
	
	/**
	 * Constructor.
	 *
	 * @access public
	 * @return void
	 */
	function ActionChain()
	{
		$this->actions = array();
	}
	
	
	/**
	 * Adds another action to the chain.
	 *
	 * @param $action Action
	 * @access public
	 * @return void
	 */
	function add(& $action)
	{
		$this->actions[] =& $action;
	}
	
	
	/**
	 * Executes the action chain.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute()
	{
		for($i=0; $i<count($this->actions); $i++) {
			$action_success = $this->actions[$i]->execute();
			if( !$action_success ) {
				return false;
			}
		}
		return true;
	}
}
?>