<?php
// View.php
include_once('lib/smarty/SmartyTemplate.php');

/** 
 * The Parent class for all Views.
 *
 * @author Matthew Lindberg
 */
class View 
{
	// string filename of Smarty template
	var $tpl_filename;
	
	// SmartyTemplate
	var $tpl;
	
	// Stopwatch for displaying page execution time
	var $timer;
	
	// Page title of view
	var $page_title;
	
	// the View's Model
	var $model;
	
	// feedback message
	var $feedback;
	
	// feedback message count
	var $numfeedback;
	
	/**
	 * Constructor.
	 *
	 * @param $timer StopWatch
	 * @access public
	 */
	function View(& $timer, & $model)
	{
		global $__CS;
		$__CS->EnterMethod("View");
		$__CS->SendObject($timer,"StopWatch");
		$__CS->SendObject($model,"Model");
		
		// Initialize default view
		$this->tpl_filename = "notplset.tpl";
		$this->tpl 			=& new SmartyTemplate($this->tpl_filename);
		$this->timer 		=& $timer;
		$this->page_title	= __APP_NAME;
		$this->model		=& $model;
		$this->feedback		= "";
		$this->numfeedback  = 0;
		
		// Set all standard header template variables
		$this->tpl->assign('homelink',__SITE_BASE_URL."index.php?mod=home");
		$this->tpl->assign('memberslink',__SITE_BASE_URL."index.php?mod=members");
		$this->tpl->assign('rankslink',__SITE_BASE_URL."index.php?mod=ranks");
		$this->tpl->assign('deedslink',__SITE_BASE_URL."index.php?mod=deeds");
		$this->tpl->assign('homelinkclass',"mainmenulinkoff");
		$this->tpl->assign('toollinkclass',"mainmenulinkoff");
		$this->tpl->assign('headerimage', __HEADER_IMG);
		
		$__CS->ExitMethod("View");
	}
	
	/**
	 * Initializes template variables based on model and form data.
	 *
	 * @access public
	 * @return void
	 */
	function init()
	{
		trigger_error(__ERROR."View:init() must be overridden in subclass.");
	}
	
	/**
	 * Adds a feedback message to this view.
	 *
	 * @param $msgarr array(strings)
	 * @access public
	 */
	function addFeedback($msgarr)
	{
		global $__CS; 
		$__CS->EnterMethod("addFeedback");
		$__CS->SendVar($msgarr,"msgarr");
		
		for($i=0; $i<count($msgarr); $i++) {
			if($this->numfeedback>0) { $this->feedback .= "<br/>"; }
			$this->feedback .= "- ".$msgarr[$i];
			$this->numfeedback++;
		}
		$this->tpl->assign('feedbackmessage', $this->feedback);
		
		$__CS->ExitMethod("addFeedback");
	}
	
	/**
	 * Sets a new template file to the View.
	 *
	 * @param $tpl_filename string
	 * @access public
	 */
	function setTemplate($tpl_filename)
	{
		global $__CS; 
		$__CS->EnterMethod("setTemplate");
		$__CS->SendVar($tpl_filename,"tpl_filename");
		
		$this->tpl_filename = $tpl_filename;
		$this->tpl->setTemplate($this->tpl_filename);
		
		$__CS->ExitMethod("setTemplate");
	}
	
	/** 
	 * Sets the title of the page.
	 *
	 * @param $title string
	 * @access public
	 */
	function setPageTitle($title)
	{
		global $__CS; 
		$__CS->EnterMethod("setPageTitle");
		$__CS->SendVar($title,"title");
		
		$this->tpl->assign('pagetitle',$title);
		
		$__CS->ExitMethod("setPageTitle");
	}
	
	/**
	 * Adds a string of text to the page title with a new seperator.
	 *
	 * @param $titletext string
	 * @access public
	 */
	function addToPageTitle($titletext)
	{
		global $__CS; 
		$__CS->EnterMethod("addToPageTitle");
		$__CS->SendVar($titletext,"titletext");
		
		$this->page_title .= " > ".(string)$titletext;
		
		$__CS->ExitMethod("addToPageTitle");
	}
	
	/**
	 * Creates a module action link of the form 
	 * http://www.mysite.com/myentrypage.php?module=mymodule&action=myaction&option1=value&option2=value
	 *
	 * @param $module string
	 * @param $action string
	 * @param $options associative array
	 * @access public
	 */
	function makeActionLink($module,$action,$options=NULL)
	{	
		global $__CS; 
		$__CS->EnterMethod("makeActionLink");
		$__CS->SendVar($module,"module");
		$__CS->SendVar($action,"action");
		$__CS->SendVar($options,"options");
		
		$link = __SITE_BASE_URL.__SITE_ENTRY_PAGE."?".__MODULE."=".$module."&".__ACTION."=".$action;
		if( $options == NULL ){
			
			$__CS->SendVar($link,"link");
			$__CS->ExitMethod("makeActionLink");
			return $link;
		}
		else {
			foreach( $options as $key => $value ) {
				$link .= "&".$key."=".$value;
			}
			$__CS->SendVar($link,"link");
			$__CS->ExitMethod("makeActionLink");
			return $link;
		}
	}
	
	/**
	 * Displays the View.
	 *
	 * @access public
	 */
	function display()
	{
		global $__CS; 
		$__CS->EnterMethod("display");
		
		$this->timer->stop();
		$this->tpl->assign('pagetitle', $this->page_title);
		$this->tpl->assign('scriptexectime',$this->timer->timeElapsed());
		$this->tpl->assign('debugon', __DEBUGON);
		$debugoutput = $__CS->GetBuffer();
		$debugoutput = str_replace("<pre>","",				$debugoutput);
		$debugoutput = str_replace("</pre>", "", 			$debugoutput);
		$debugoutput = str_replace("\n","<br/>",			$debugoutput);
		$debugoutput = str_replace(" ","&nbsp;&nbsp;&nbsp;",$debugoutput);
		$this->tpl->assign('traceoutput', $debugoutput);
		$this->tpl->display();
	}
	
	/**
	 * Returns an html breadcrumb trail for this view.
	 *
	 * @access public
	 */
	function getBreadcrumbs()
	{
		trigger_error(__ERROR.": Must override getBreadcrumbs method in child class");
	}

}
?>