<?php
// DeedController.php
include_once('core/base/ModuleController.php');
include_once('core/deeds/models/DeedModel.php');

/**
 *
 * @author Matthew Lindberg
 */
class DeedController extends ModuleController
{
	
	/**
	 * Constructor.
	 *
	 * @param $data_access DataAccess
	 * @param $timer StopWatch
	 * @access public
	 */
	function DeedController(& $data_access, & $session, & $timer, & $front_controller)
	{
		global $__CS; 
		$__CS->EnterMethod("DeedController");
		$__CS->SendObject($data_access,"DataAccess");
		$__CS->SendObject($timer,"StopWatch");
		
		$model =& new DeedModel(& $data_access);
		parent::ModuleController(& $data_access, & $session, & $model, & $timer, & $front_controller);
		
		$__CS->ExitMethod("DeedController");
	}
	
	
	
	/**
	 * Processes a request.
	 *
	 * @param $request Request
	 * @access public
	 */
	function processRequest(& $request)
	{
		global $__CS; 
		$__CS->EnterMethod("processRequest");
		$__CS->SendObject($request,"Request");
		
		$this->request =& $request;
		$this->setRequestContext(& $this->request, & $this);
		
		// Register actions
		include_once('core/base/ActionHandler.php');
		$handler =& new ActionHandler( "core/deeds/actions/",& $this->context);
		$handler->registerAction(__DEED_NEW,	"NewDeed");
		$handler->registerAction(__DEED_SEARCH,	"SearchDeeds");
		$handler->registerAction(__DEED_ADD_NEW,"InsertNewDeed");
		$handler->registerAction(__DEED_EDIT,	"EditDeed");
		$handler->registerAction(__DEED_UPDATE,	"UpdateDeed");
		$handler->registerAction(__DEED_DELETE, "DeleteDeed");
		
		// Handle action
		$show_view = $handler->execute($this->request->get(__ACTION));
		
		if($show_view && ($this->view != NULL)) {
			$this->view->display();
		}
		$__CS->ExitMethod("processRequest");
	}
}
?>