<?php
// DeleteDeed.php
include_once('core/base/Action.php');

/**
 * Deletes a deed using a deed id.
 * 
 *
 * @author Matthew Lindberg
 * @todo Make execute functon set ErrorView in controller on error instead of triggering error.
 */
class DeleteDeed extends Action
{
	
	/**
	 * Executes action.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS;
		$__CS->EnterMethod("execute");
		
		$request	=& $context->getEntry(__REQUEST);
		$model		=& $context->getEntry(__MODEL);
		
		$id = $request->get("id");
		
		if( !$model->delete($id) ) {
			trigger_error(__ERROR."Could not delete deed in DeleteDeed.php");
			$__CS->ExitMethod("execute");
			return false;
		}
		
		$request->addFeedback("Deed #".$id." has been deleted");
		
		// Now, redirect control to the deed search view
		$request->set(__ACTION,__DEED_SEARCH);
		$controller  =& $context->getEntry(__CONTROLLER);
		$controller->processRequest(& $request);
		
		$__CS->ExitMethod("execute");
		return false;
	}
}
?>