<?php
// SearchDeeds.php
include_once('core/base/Action.php');

/**
 * Searches for a deed based on search request parameters.
 * 
 * Sets view to paginated deed results page, or an error view on failure.
 *
 * @author Matthew Lindberg
 * @todo Make execute functon set ErrorView in controller on error instead of triggering error.
 */
class SearchDeeds extends Action
{
	/**
	 * Executes the search deeds action.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS;
		$__CS->EnterMethod("execute");
		
		$model  	=& $context->getEntry(__MODEL);
		$request 	=& $context->getEntry(__REQUEST);
		$timer		=& $context->getEntry(__TIMER);
		
		include_once('core/deeds/views/DeedSearchView.php');
		$view =& new DeedSearchView(& $timer, & $model);
		
		if($page_num = $request->get('page')) {
			$search_index = ($page_num * __MAX_DEED_RESULTS) - __MAX_DEED_RESULTS;
			list($collection,$count) = $model->searchAll($search_index);
			$view->setPageNumber($page_num);
		}
		else {
			list($collection,$count) = $model->searchAll();
			$view->setPageNumber(1);
		}
		
		$view->setNumberOfSearchResults($count);
		
		$num_pages = ceil($count / __MAX_DEED_RESULTS);
		if( $num_pages == 0 ) {
			$num_pages = 1;
		}
		
		$view->setTotalPages($num_pages);
		$view->setResultRows(& $collection);
		
		// Add any feedback messages, if they exist
		if($request->hasFeedback()) {
			$view->addFeedback($request->getFeedback());
		}
		$view->init();
		
		$controller =& $context->getEntry(__CONTROLLER);
		$controller->setView(& $view);
		
		$__CS->ExitMethod("execute");
		return true;
	}
}
?>