<?php
// UpdateDeed.php
include_once('core/base/Action.php');

/**
 * Saves a new deed to the database from a submitted deed form.
 * 
 * Set view to a new blank deed form on success, or an error view on failure.
 *
 * @author Matthew Lindberg
 * @todo Make execute functon set ErrorView in controller on error instead of triggering error.
 */
class UpdateDeed extends Action
{
	/**
	 * 
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS;
		$__CS->EnterMethod("execute");
		
		$session 	=& $context->getEntry(__SESSION);
		$request	=& $context->getEntry(__REQUEST);
		$timer		=& $context->getEntry(__TIMER);
		
		include_once('core/deeds/forms/DeedForm.php');
		$deed_form =& new DeedForm(& $session, & $request);
		$deed_form->loadFromRequest();
		
		$model 	=& $context->getEntry(__MODEL);
		$model->loadFromForm( & $deed_form );
		if( !$model->save() ) {
			trigger_error(__ERROR."Could not save deed in UpdateDeedFromForm.php");
			$__CS->ExitMethod("execute");
			return false;
		}
		$request->addFeedback("deed has been updated successfully");
		
		include_once('core/deeds/views/DeedEditFormView.php');
		$view 	=& new DeedEditFormView(& $timer, & $model, & $deed_form);
		$view->addFeedback($request->getFeedback());
		$view->init();
		
		$controller =& $context->getEntry(__CONTROLLER);
		$controller->setView( & $view );
		
		$__CS->ExitMethod("execute");
		return true;
	}
}
?>