<?php
// DeedForm.php
include_once('core/base/Form.php');

/**
 * Form for creation and editing of deeds.
 *
 * @author Matthew Lindberg
 */
class DeedForm extends Form
{
	var $_EditExisting	= "editexisting";
	var $_DeedID		= "deedid";
	var $_DeedName		= "deedname";
	var $_DeedDesc		= "deeddesc";
	var $_MultiComplete = "multicompletion";
	var $_Difficulty 	= "difficulty";
	var $_GPGuild0      = "gpguild0";
	var $_GPGuild1      = "gpguild1";
	var $_GPGuild2      = "gpguild2";
	var $_GPQuest0      = "gpquest0";
	var $_GPQuest1      = "gpquest1";
	var $_GPQuest2      = "gpquest2";
	var $_GPPvp0      	= "gppvp0";
	var $_GPPvp1      	= "gppvp1";
	var $_GPPvp2      	= "gppvp2";
	
	
	/**
	 * Constructor.
	 *
	 * @access public
	 */
	function DeedForm(& $session, & $request)
	{
		global $__CS; 
		$__CS->EnterMethod("DeedForm");
		$__CS->SendObject($session,"session");
		$__CS->SendObject($request,"request");
		
		parent::Form(& $session, & $request);
		$this->init();
		
		$__CS->ExitMethod("DeedForm");
	}

	/**
	 * Sets all of the default values for this form.
	 *
	 * @access public
	 */
	function init()
	{
		global $__CS; 
		$__CS->EnterMethod("setDefaultValues");
		
		$this->setField($this->_EditExisting,	0);
		$this->setField($this->_DeedID,			NULL);
		$this->setField($this->_DeedName,		"");	
		$this->setField($this->_DeedDesc,		"");
		$this->setField($this->_MultiComplete, 	1);
		$this->setField($this->_Difficulty,		"easy");
		$this->setField($this->_GPGuild0, 		0);
		$this->setField($this->_GPGuild1,		0);
		$this->setField($this->_GPGuild2, 		0);
		$this->setField($this->_GPQuest0,		0);
		$this->setField($this->_GPQuest1,		0);
		$this->setField($this->_GPQuest2,		0);
		$this->setField($this->_GPPvp0,			0);
		$this->setField($this->_GPPvp1,			0);
		$this->setField($this->_GPPvp2,			0);
		
		$__CS->ExitMethod("setDefaultValues");	
	}
	
	/**
	 * Loads the form with a DeedModel.
	 *
	 * @param $model
	 * @access public
	 */
	function loadFromModel(& $model)
	{
		global $__CS; 
		$__CS->EnterMethod("loadFromModel");
		$__CS->SendObject($model,"model");
		
		( $model->isExisting() )
		? $this->setField($this->_EditExisting,1)
		: $this->setField($this->_EditExisting,0);
		
		$this->setField( $this->_DeedID, 		$model->getDeedID() );
		$this->setField( $this->_DeedName, 		$model->getDeedName() );
		$this->setField( $this->_DeedDesc,		$model->getDeedDesc() );
		$this->setField( $this->_MultiComplete,	$model->getMultiCompletion() );
		$this->setField( $this->_Difficulty,	$model->getDifficulty() );
		
		include_once('lib/math/Integer.php');
		
		$guildGP = $model->getGuildGP();
		$questGP = $model->getQuestGP();
		$pvpGP	 = $model->getPvpGP();
		
		$this->setField($this->_GPGuild0, 	Integer::getDigit($guildGP,0));
		$this->setField($this->_GPGuild1,	Integer::getDigit($guildGP,1));
		$this->setField($this->_GPGuild2, 	Integer::getDigit($guildGP,2));
		$this->setField($this->_GPQuest0,	Integer::getDigit($questGP,0));
		$this->setField($this->_GPQuest1,	Integer::getDigit($questGP,1));
		$this->setField($this->_GPQuest2,	Integer::getDigit($questGP,2));
		$this->setField($this->_GPPvp0,		Integer::getDigit($pvpGP,0));
		$this->setField($this->_GPPvp1,		Integer::getDigit($pvpGP,1));
		$this->setField($this->_GPPvp2,		Integer::getDigit($pvpGP,2));
		
		$__CS->ExitMethod("loadFromModel");
	}
	
	/**
	 * Gets the deed existing status of the form.
	 *
	 * @access public
	 * @return integer 0 if form data doesn't exist in database, 1 if it does
	 */
	function getExisting()
	{
		global $__CS; 
		$__CS->EnterMethod("getExisting");
		
		$value = (int)$this->getFieldValue($this->_EditExisting);
		
		$__CS->ExitMethod("getExisting");
		return $value;
	}
	
	/**
	 * Gets the deed id of the form if the form is used to edit on existing deed.
	 *
	 * @access public
	 * @return integer or null 
	 */
	function getDeedID()
	{
		global $__CS; 
		$__CS->EnterMethod("getDeedID");
		
		$value = (int)$this->getFieldValue($this->_DeedID);
		
		$__CS->ExitMethod("getDeedID");
		return $value;
	}
	
	/**
	 * Gets the name of the deed.
	 *
	 * @access public
	 * @return string
	 */
	function getDeedName()
	{
		global $__CS; 
		$__CS->EnterMethod("getDeedName");
		
		$value = (string)$this->getFieldValue($this->_DeedName);
		
		$__CS->ExitMethod("getDeedID");
		return $value;
	}
	
	/**
	 * Gets the full deed description.
	 *
	 * @access public
	 * @return string
	 */
	function getDeedDesc()
	{
		global $__CS; 
		$__CS->EnterMethod("getDeedDesc");
		
		$value = (string)$this->getFieldValue($this->_DeedDesc);
		
		$__CS->ExitMethod("getDeedDesc");
		return $value;
	}
	
	/**
	 * Gets the multi completion status of the deed.
	 *
	 * @access public
	 * @return integer 0 | 1
	 */
	function getMultiCompletion()
	{
		global $__CS; 
		$__CS->EnterMethod("getMultiCompletion");
		
		$value = (int)$this->getFieldValue($this->_MultiComplete);
		
		$__CS->ExitMethod("getMultiCompletion");
		return $value;
	}
	
	/**
	 * Gets the difficulty of the deed.
	 *
	 * @access public
	 * @return string [easy | medium | hard | epic]
	 */
	function getDifficulty()
	{
		global $__CS; 
		$__CS->EnterMethod("getDifficulty");
		
		$value = (string)$this->getFieldValue($this->_Difficulty);
		
		$__CS->ExitMethod("getDifficulty");
		return $value;
	}
	
	/**
	 * Gets the total guild guild points.
	 *
	 * @access public
	 * @return integer
	 */
	function getGuildGP()
	{
		global $__CS; 
		$__CS->EnterMethod("getGuildGP");
		
		$p1 = (int)$this->getFieldValue($this->_GPGuild0);
		$p2 = (int)$this->getFieldValue($this->_GPGuild1);
		$p3 = (int)$this->getFieldValue($this->_GPGuild2);
		
		$value = ( $p1 + (10*$p2) + (100*$p3) );
		
		$__CS->ExitMethod("getGuildGP");
		return $value;
	}
	
	/**
	 * Gets the total quest guild points.
	 *
	 * @access public
	 * @return integer
	 */
	function getQuestGP()
	{
		global $__CS; 
		$__CS->EnterMethod("getQuestGP");
		
		$p1 = (int)$this->getFieldValue($this->_GPQuest0);
		$p2 = (int)$this->getFieldValue($this->_GPQuest1);
		$p3 = (int)$this->getFieldValue($this->_GPQuest2);
		
		$value = ( $p1 + (10*$p2) + (100*$p3) );
		
		$__CS->ExitMethod("getQuestGP");
		return $value;
	}
	
	/**
	 * Gets teh total pvp guild points.
	 *
	 * @access public
	 * @return integer
	 */
	function getPvpGP()
	{
		global $__CS; 
		$__CS->EnterMethod("getPvpID");
		
		$p1 = (int)$this->getFieldValue($this->_GPPvp0);
		$p2 = (int)$this->getFieldValue($this->_GPPvp1);
		$p3 = (int)$this->getFieldValue($this->_GPPvp2);
		
		$value = ( $p1 + (10*$p2) + (100*$p3) );
		
		$__CS->ExitMethod("getPvpID");
		return $value;
	}
}
?>