<?php
// DeedEditFormView.php
include( 'core/deeds/views/DeedView.php');


/**
 * 
 * @author Matthew Lindberg
 */
class DeedEditFormView extends DeedView
{
	// DeedForm
	var $deed_form;
	
	var $pagenum_from;
	
	/**
	 * Constructor.
	 *
	 * @param $timer StopWatch
	 * @param $deed_model DeedModel
	 * @param $deed_form DeedForm
	 * @access public
	 */
	function DeedEditFormView(& $timer, & $deed_model, & $deed_form)
	{
		global $__CS;
		$__CS->EnterMethod("DeedEditFormView");
		$__CS->SendObject($timer,"timer");
		$__CS->SendObject($deed_model,"deed_model");
		$__CS->SendObject($deed_form,"deed_form");
		
		// instantiate parent class
		parent::DeedView(& $timer, & $deed_model);
		
		// Set all template variables
		
		$this->setTemplate("deed_edit.tpl");
		$this->deed_form =& $deed_form;
		$this->pagenum_from = NULL;
		
		$__CS->ExitMethod("DeedEditFormView");
	}
	
	/**
	 * Sets the page number that requested a new member edit.
	 *
	 * @param $page integer
	 * @access public
	 */
	function setPageFrom($page)
	{
		$this->pagenum_from = $page;
	}
	
	/**
	 * Sets all the Smarty template variables for this View.
	 *
	 * @param $use_form_values boolean
	 * @access public
	 */
	function init()
	{
		global $__CS;
		$__CS->EnterMethod("init");
		
		parent::init();
		
		// Set module submenu
		$modulemenu = array(
							array("name" 	=> "search",
								"class" 	=> "off",
								"href"	=> $this->makeActionLink(__DEED,__DEED_SEARCH)
								 ),
							array("name"	=> "new",
								  "class"	=> "off",
								  "href"	=> $this->makeActionLink(__DEED,__DEED_NEW)
								));

		$existing = $this->deed_form->getExisting(); 
		if( $existing ) {
			$this->tpl->assign( "rightcolumntitle", "Edit Deed" );
			$this->tpl->assign( "formaction",      	$this->makeActionLink(__DEED,__DEED_UPDATE,array("pageback" => $this->pagenum_from)));
			$this->addToPageTitle("Edit Deed");
			$this->tpl->assign( "backbuttonlink", $this->makeActionLink(__DEED,__DEED_SEARCH,array("page" => $this->pagenum_from)));
			
		}
		else {
			$this->tpl->assign( "rightcolumntitle", "Create New Deed" );
			$this->tpl->assign( "formaction",      	$this->makeActionLink(__DEED,__DEED_ADD_NEW));
			$this->addToPageTitle("Create New Deed");
			$this->tpl->assign( "backbuttonlink", "false" );
			$modulemenu[1]["class"] = "on";
		}
		$this->tpl->assign( "modulemenu", $modulemenu );
		
		$this->tpl->assign( "deedname", 		$this->deed_form->getFormInput($this->deed_form->_DeedName) );
		$this->tpl->assign( "deeddesc", 		$this->deed_form->getFormInput($this->deed_form->_DeedDesc) );
		$this->tpl->assign( "multicompletion", 	$this->deed_form->getFormInput($this->deed_form->_MultiComplete) );
		$this->tpl->assign( "difficulty", 		$this->deed_form->getFormInput($this->deed_form->_Difficulty) );
		
		// Set array of values to use for guild points drop-down menus
		$gpoptions = array( 	0=>0, 1=>1, 2=>2, 3=>3, 4=>4, 5=>5,
								5=>5, 6=>6, 7=>7, 8=>8, 9=>9 );
						
		$this->tpl->assign( "gpoptions", $gpoptions);
		
		$this->tpl->assign( "gpguild1",  	$this->deed_form->getFormInput($this->deed_form->_GPGuild0) );
		$this->tpl->assign( "gpguild2",  	$this->deed_form->getFormInput($this->deed_form->_GPGuild1) );
		$this->tpl->assign( "gpguild3",  	$this->deed_form->getFormInput($this->deed_form->_GPGuild2) );
		
		$this->tpl->assign( "gpquest1",  	$this->deed_form->getFormInput($this->deed_form->_GPQuest0) );
		$this->tpl->assign( "gpquest2",  	$this->deed_form->getFormInput($this->deed_form->_GPQuest1) );
		$this->tpl->assign( "gpquest3",  	$this->deed_form->getFormInput($this->deed_form->_GPQuest2) );
		
		$this->tpl->assign( "gppvp1",	 	$this->deed_form->getFormInput($this->deed_form->_GPPvp0) );
		$this->tpl->assign( "gppvp2", 	 	$this->deed_form->getFormInput($this->deed_form->_GPPvp1) );
		$this->tpl->assign( "gppvp3",    	$this->deed_form->getFormInput($this->deed_form->_GPPvp2) );
		
		$this->tpl->assign( "editexisting", $this->deed_form->getFormInput($this->deed_form->_EditExisting) );
		$this->tpl->assign( "deedid",		$this->deed_form->getFormInput($this->deed_form->_DeedID) );
		
		$__CS->ExitMethod("init");
	}
	
	/**
	 *
	 * @access public
	 */
	function getBreadcrumbs()
	{
		global $__CS; 
		$__CS->EnterMethod("getBreadcrumbs");
		
		return parent::getBreadcrumbs()." - <a href=".__SITE_BASE_URL."index.php?".__MODULE."=deeds&".__ACTION."=new>New Deed</a>";
		
		$__CS->ExitMethod("getBreadcrumbs");
	}
}


?>