<?php
// DeedSearchView.php
include( 'core/deeds/views/DeedView.php');


/**
 * 
 * @author Matthew Lindberg
 *
 * @todo template var linkdetail doesn't do anything at this point.  If detail page is necessary, add it.
 */
class DeedSearchView extends DeedView
{
	// The current page number of search results
	var $page_number;
	
	// Total number of pages
	var $tot_pages;
	
	// The total number of search results
	var $num_search_results;
	
	// DBRow collection
	var $result_rows;
	
	
	/**
	 * Constructor.
	 *
	 * @access public
	 */
	function DeedSearchView(& $timer, & $deed_model)
	{
		global $__CS;
		$__CS->EnterMethod("DeedSearchView");
		$__CS->SendObject($timer,"timer");
		$__CS->SendObject($deed_model,"deed_model");
		
		// instantiate parent class
		parent::DeedView(& $timer, & $deed_model);
		
		// Set all template variables
		$this->addToPageTitle("Find Deed");
		$this->setTemplate("deed_find.tpl");
		
		$this->page_number 			= NULL;
		$this->tot_pages			= NULL;
		$this->num_search_results 	= NULL;
		$this->results_rows 		= NULL;
		
		$__CS->ExitMethod("DeedSearchView");
	}
	
	/**
	 * Sets the search views page number.
	 *
	 * @param $num integer
	 * @access public
	 * @return void
	 */
	function setPageNumber($num)
	{
		global $__CS;
		$__CS->EnterMethod("setPageNumber");
		$__CS->SendVar($num,"num");
		
		$this->page_number = $num;
		
		$__CS->ExitMethod("setPageNumber");
	}
	
	function setTotalPages($num)
	{
		$this->tot_pages = $num;
	}
	
	/**
	 * Sets the total number of search results.
	 *
	 * @param $num integer
	 * @access public
	 * @return void
	 */
	function setNumberOfSearchResults($num)
	{
		global $__CS;
		$__CS->EnterMethod("setNumberOfSearchResults");
		
		$this->num_search_results = $num;
		
		$__CS->ExitMethod("setNumberOfSearchResults");
	}
	
	/**
	 * Sets the views collection of search result rows.
	 *
	 * @param $row_collection arrayDBRows
	 * @access public
	 * @return void
	 */
	function setResultRows(& $rows)
	{
		global $__CS;
		$__CS->EnterMethod("setResultRows");
		$__CS->SendObject($rows,"rows");
		
		$this->result_rows =& $rows;
		
		$__CS->ExitMethod("setResultRows");
	}
	
	
	/**
	 * Sets all the Smarty template variables for this View.
	 *
	 * @access private
	 */
	function init()
	{
		global $__CS;
		parent::init();
		
		// Set module submenu
		$this->tpl->assign("modulemenu" , array(
													array("name" 	=> "search",
														  "class" 	=> "on",
														  "href"	=> $this->makeActionLink(__DEED,__DEED_SEARCH)
														 ),
													array("name"	=> "new",
														  "class"	=> "off",
														  "href"	=> $this->makeActionLink(__DEED,__DEED_NEW)
														 )
											    ));
				   
		// builds paginated result view from search results rows
		if( $this->result_rows == NULL ) { trigger_error(__ERROR."DBRow search results not set in DeedSearchView.  Cannot Render View."); }
		$deeds = array();
		$iter =& $this->result_rows->createIterator();
		
		while( !$iter->isDone() ) {
			$row =& $iter->fetch();
			$this->model->loadFromDBRow(& $row);
			
			$next_deed = array();
			$next_deed['name'] 			= $this->model->getDeedName();
			$next_deed['description']	= $this->model->getDeedDesc();
			$next_deed['difficulty']	= $this->model->getDifficulty();
			$next_deed['gpguild']		= $this->model->getGuildGP();
			$next_deed['gpquest']		= $this->model->getQuestGP();
			$next_deed['gppvp']			= $this->model->getPvpGP();
			
			// Next, create action links for deed result
			$deed_id = $this->model->getDeedID();
			$next_deed['linkedit'] = $this->makeActionLink(__DEED,__DEED_EDIT,array("id" => $deed_id, "pageback" => $this->page_number));
			$next_deed['linkdetail'] = $this->makeActionLink(__DEED,__DEED_EDIT,array("id" => $deed_id, "pageback" => $this->page_number));
			$next_deed['linkdelete'] = $this->makeActionLink(__DEED,__DEED_DELETE,array("id" => $deed_id, "page" => $this->page_number));
			
			$deeds[] = $next_deed;
		}
		$this->tpl->assign( "deed", $deeds );
		 
		
		
		
		if( ($this->page_number == NULL) || ($this->num_search_results == NULL) || ($this->tot_pages == NULL) ) {
			trigger_error(__ERROR."Page number, total pages, and number of search results must be set in DeedSearchView. Cannot render view.");
		}
		
		$this->tpl->assign( "rightcolumntitle", "The Book of Deeds" );
		$this->tpl->assign( "totaldeeds", $this->num_search_results );
		$this->tpl->assign( "pagenumber", $this->page_number);
		$this->tpl->assign( "totalpages", $this->tot_pages);
		
		// Set all 'page back' links
		if( $this->page_number == 1 ) {
			$this->tpl->assign( "linkallpageback", "none" );
			$this->tpl->assign( "linkonepageback", "none" );
		}
		else {
			$this->tpl->assign( "linkallpageback", $this->makeActionLink(__DEED,__DEED_SEARCH,array("page" => 1)) );
			$this->tpl->assign( "linkonepageback", $this->makeActionLink(__DEED,__DEED_SEARCH,array("page" => ($this->page_number-1))));
		}
		
		// Set all 'page forward' links
		if( $this->page_number == $this->tot_pages ) {
			$this->tpl->assign( "linkallpageforward", "none" );
			$this->tpl->assign( "linkonepageforward", "none" );
		}
		else {
			$this->tpl->assign( "linkallpageforward", $this->makeActionLink(__DEED,__DEED_SEARCH,array("page" => $this->tot_pages)));
			$this->tpl->assign( "linkonepageforward", $this->makeActionLink(__DEED,__DEED_SEARCH,array("page" => ($this->page_number+1))));
		}
		
		
		$this->tpl->assign( "javascript", array(__DIR_ABS_JAVASCRIPT."confirmRequest.js",
												__DIR_ABS_JAVASCRIPT."setViewedSearchbox.js") );
		$this->tpl->assign( "onloadfunction", "return setViewedSearchbox(advancedsearch);" );
		$this->tpl->assign( "searchtype", "advancedsearch");
	}
	
	/**
	 *
	 * @access public
	 */
	function getBreadcrumbs()
	{
		global $__CS; 
		$__CS->EnterMethod("getBreadcrumbs");
		
		return parent::getBreadcrumbs()." - <a href=".__SITE_BASE_URL."index.php?".__MODULE."=deeds&".__ACTION."=find>Find Deed</a>";
		
		$__CS->ExitMethod("getBreadcrumbs");
	}
}


?>