<?php
// MemberController.php
include_once('core/base/ModuleController.php');
include_once('core/members/models/MemberModel.php');

/**
 *
 * @author Matthew Lindberg
 */
class MemberController extends ModuleController
{
	
	/**
	 * Constructor.
	 *
	 * @param $data_access DataAccess
	 * @param $timer StopWatch
	 * @access public
	 */
	function MemberController(& $data_access, & $session, & $timer, & $front_controller)
	{
		global $__CS; 
		$__CS->EnterMethod("MemberController ** Constructor");
		$__CS->SendObject($data_access,"DataAccess");
		$__CS->SendObject($timer,"StopWatch");
		
		$model =& new MemberModel(& $data_access);
		parent::ModuleController(& $data_access, & $session, & $model, & $timer, & $front_controller);
		
		$__CS->ExitMethod("MemberController ** Constructor");
	}
	
	
	
	/**
	 * Processes a request.
	 *
	 * @param $request Request
	 * @access public
	 */
	function processRequest(& $request)
	{
		global $__CS; 
		$__CS->EnterMethod("processRequest:MemberController");
		$__CS->SendObject($request,"Request");
		
		$this->request =& $request;
		$this->setRequestContext(& $this->request, & $this);
		
		// Register actions
		include_once('core/base/ActionHandler.php');
		$handler =& new ActionHandler( "core/members/actions/",& $this->context);
		$handler->registerAction(__MEMBER_SEARCH,			"SearchMembers");
		$handler->registerAction(__MEMBER_NEW,				"NewMember");
		$handler->registerAction(__MEMBER_INSERT_NEW, 		"InsertNewMember");
		$handler->registerAction(__MEMBER_EDIT,				"EditMember");
		$handler->registerAction(__MEMBER_UPDATE,			"UpdateMember");
		$handler->registerAction(__MEMBER_ALIAS_DELETE,		"DeleteAlias");
		$handler->registerAction(__MEMBER_ALIAS_NEW,		"NewAlias");
		$handler->registerAction(__MEMBER_ALIAS_EDIT,		"EditAlias");
		$handler->registerAction(__MEMBER_ALIAS_INSERT_NEW, "InsertNewAlias");
		$handler->registerAction(__MEMBER_ALIAS_UPDATE,		"UpdateAlias");
		$handler->registerAction(__MEMBER_ALIAS_SETASMAIN,	"SetAliasAsMain");
		$handler->registerAction(__MEMBER_SELECT_DEEDLOG_DEEDS, "SelectDeeds");
		$handler->registerAction(__MEMBER_INSERT_DEEDLOG_DEEDS, "InsertDeeds");
		$handler->registerAction(__MEMBER_SELECT_RESPONS,	"SelectResponsibilities");
		$handler->registerAction(__MEMBER_INSERT_RESPONS,	"InsertResponsibilities");
		$handler->registerAction(__MEMBER_DELETE,			"DeleteMember");
		$handler->registerAction(__MEMBER_DELETE_DEEDLOG_DEED, "DeleteDeedlogDeed");
		$handler->registerAction(__MEMBER_INSERT_NOTE,		"InsertNewNote");
		$handler->registerAction(__MEMBER_NOTE_POPUP,		"ViewNotePopup");
		$handler->registerAction(__MEMBER_DELETE_NOTE,		"DeleteNote");
		
		// Handle action
		$show_view = $handler->execute($this->request->get(__ACTION));
		
		if($show_view && ($this->view != NULL)) {
			
			$this->view->display();
		}
		$__CS->ExitMethod("processRequest:MemberController");
	}
}
?>