<?php
// DeleteAlias.php
include_once('core/base/Action.php');

/**
 * Deletes a member's alias.
 *
 * @author Matthew Lindberg
 */
class DeleteAlias extends Action
{
	
	/**
	 * Sets view to the edit member form.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS; 
		$__CS->EnterMethod("execute:DeleteAlias");
		
		$request	=& $context->getEntry(__REQUEST);
		$model		=& $context->getEntry(__MODEL);
		$controller =& $context->getEntry(__CONTROLLER);
		
		$member_id = $request->get("memberid");
		$alias_id = $request->get("aliasid");
		
		if( !$model->deleteAlias($member_id,$alias_id)) {
			die("Problem deleting member alias in DeleteAlias action");
		}
		
		$request->addFeedback("successfully deleted alias");
		
		$request->set(__ACTION,__MEMBER_EDIT);
		$request->set("id",$member_id);
		$request->set("section","aliassection");
		
		$controller->processRequest(& $request);
		
		$__CS->ExitMethod("execute:DeleteAlias");
		return false;
	}
	
}
?>