<?php
// DeleteDeedlogDeed.php
include_once('core/base/Action.php');

/**
 * Deletes a deedlog deed.
 *
 * @author Matthew Lindberg
 */
class DeleteDeedlogDeed extends Action
{
	
	/**
	 * Sets view to the edit member form.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		$request	=& $context->getEntry(__REQUEST);
		$model		=& $context->getEntry(__MODEL);
		$controller =& $context->getEntry(__CONTROLLER);
		
		$member_id = $request->get("memberid");
		$deed_id = $request->get("deedid");
		
		if( !$model->deleteDeedlogDeed($member_id, $deed_id)) {
			die("Problem deleting deed entry in DeleteDeedlogDeed action");
		}
		
		$request->addFeedback("successfully deleted deed");
		
		$request->set("id",$member_id);
		$request->set("section","deedlogsection");
		$request->set(__ACTION,__MEMBER_EDIT);
		
		$controller->processRequest(& $request);
	
		return false;
	}
	
}
?>