<?php
// DeleteNote.php
include_once('core/base/Action.php');

/**
 * Deletes a member.
 *
 * @author Matthew Lindberg
 */
class DeleteNote extends Action
{
	
	/**
	 * Deletes a note.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		$request	=& $context->getEntry(__REQUEST);
		$model		=& $context->getEntry(__MODEL);
		$controller =& $context->getEntry(__CONTROLLER);
		
		$member_id = $request->get("memberid");
		$note_id   = $request->get("noteid");
		
	
		
		if( !$model->deleteNote($note_id)) {
			die("Problem deleting note in DeleteNote action");
		}
		
		$request->addFeedback("successfully deleted note");
		
		$request->set(__ACTION,__MEMBER_EDIT);
		$request->set("id",$member_id);
		
		$controller->processRequest(& $request);
		
		return false;
	}
	
}
?>