<?php
// EditAlias.php
include_once('core/base/Action.php');

/**
 * Opens a edit member form.
 *
 * @author Matthew Lindberg
 */
class EditAlias extends Action
{
	
	/**
	 * Sets view to the edit member form.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS; 
		$__CS->EnterMethod("execute:EditAlias");
		
		$session	=& $context->getEntry(__SESSION);
		$request	=& $context->getEntry(__REQUEST);
		$timer		=& $context->getEntry(__TIMER);
		$model		=& $context->getEntry(__MODEL);
		
		include_once('core/members/forms/AliasEditForm.php');
		$alias_form =& new AliasEditForm(& $session, & $request);
		
		$member_id = $request->get("memberid");
		$alias_id = $request->get("aliasid");
		
		$alias_form->loadFromModel(& $model, $alias_id);
		$model->setMemberID($member_id);
		
		include_once('core/members/views/AliasEditView.php');
		
		$view =& new AliasEditView(& $timer, & $model, & $alias_form);
		
		// Add any feedback messages, if they exist
		if($request->hasFeedback()) {
			$view->addFeedback($request->getFeedback());
		}
		$view->init();
		
		$controller =& $context->getEntry(__CONTROLLER);
		$controller->setView(& $view);
		
		$__CS->ExitMethod("execute:EditAlias");
		return true;
	}
	
}
?>