<?php
// InsertNewMember.php
include_once('core/base/Action.php');

/**
 * Saves a member.
 * 
 *
 * @author Matthew Lindberg
 */
class InsertNewMember extends Action
{
	
	/**
	 * 
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS;
		$__CS->EnterMethod("execute:InsertNewMember");
		
		$session 	=& $context->getEntry(__SESSION);
		$request	=& $context->getEntry(__REQUEST);
		$timer		=& $context->getEntry(__TIMER);
		
		include_once('core/members/forms/MemberEditForm.php');
		$member_form 	=& new MemberEditForm(& $session, & $request);
		$member_form->loadFromRequest();
		
		$model 		=& $context->getEntry(__MODEL);
		
		if( !$model->saveFromNewForm( & $member_form )) {
			die("Error saving new member in InsertNewMember");
		}
		
		$request->addFeedback("new member has been successfully created");
		$request->addFeedback($member_form->getMainCharName()." set as main character");
		
		// Clear the deed form and set the view to a blank new deed form, along with feedback
		// showing a successful deed addition
		$member_form->init();
		
		include_once('core/members/views/MemberNewView.php');
		$view 	=& new MemberNewView(& $timer, & $model, & $member_form);
		$view->addFeedback($request->getFeedback());
		$view->init();
		
		$controller  =& $context->getEntry(__CONTROLLER);
		$controller->setView( & $view );
		$__CS->ExitMethod("execute:InsertNewMember");
		return true;
	}
}
?>