<?php
// MemberEditForm.php
include_once('core/base/Form.php');

/**
 * 
 *
 * @author Matthew Lindberg
 */
class MemberEditForm extends Form
{
	var $_Login 			= "memberlogin";
	var $_EMail				= "memberemail";
	var $_RankID			= "rankid";
	var $_MainCharSex 		= "maincharsex";
	var $_MainCharName		= "maincharname";
	var $_MainCharRaceID	= "maincharraceid";
	var $_MainCharClassID	= "maincharclassid";
	var $_MainCharLevel		= "maincharlevel";
	var $_EnableThottbot	= "enablethottbot";
	var $_ServerID			= "serverid";
	
	
	/**
	 * Constructor.
	 *
	 * @access public
	 */
	function MemberEditForm(& $session, & $request)
	{
		global $__CS; 
		$__CS->EnterMethod("MemberEditForm ** Constructor");
		$__CS->SendObject($session,"session");
		$__CS->SendObject($request,"request");
		
		parent::Form(& $session, & $request);
		$this->init();
		
		$__CS->ExitMethod("MemberEditForm ** Constructor");
	}

	/**
	 * Sets all of the default values for this form.
	 *
	 * @access public
	 */
	function init()
	{
		global $__CS; 
		$__CS->EnterMethod("setDefaultValues:MemberEditForm");
		
		$this->setField($this->_Login,				"");
		$this->setField($this->_EMail,				"");	
		$this->setField($this->_RankID,				NULL);
		$this->setField($this->_MainCharSex,		"m");
		$this->setField($this->_MainCharName,		"");
		$this->setField($this->_MainCharRaceID,		NULL);
		$this->setField($this->_MainCharClassID,	NULL);
		$this->setField($this->_MainCharLevel,		1);
		$this->setField($this->_EnableThottbot,		0);
		$this->setField($this->_ServerID,			NULL);
		
		$__CS->ExitMethod("setDefaultValues:MemberEditForm");	
	}
	
	/**
	 * Loads the form with a DeedModel.
	 *
	 * @param $model
	 * @access public
	 */
	function loadFromModel(& $model)
	{
		global $__CS; 
		$__CS->EnterMethod("loadFromModel:MemberNewForm");
		$__CS->SendObject($model,"model");
		
		$this->setField( $this->_Login,	$model->getLogin());
		$this->setField( $this->_EMail,	$model->getEMail());
		$this->setField( $this->_RankID,$model->getRankID());
		
		$main_char =& $model->getMainCharacter();
		$this->setField( $this->_MainCharSex,		$main_char->getSex());
		$this->setField( $this->_MainCharName,		$main_char->getName());
		$this->setField( $this->_MainCharRaceID,	$main_char->getRaceID());
		$this->setField( $this->_MainCharClassID,	$main_char->getClassID());
		$this->setField( $this->_MainCharLevel,		$main_char->getLevel());
		$this->setField( $this->_EnableThottbot, 	$main_char->isThottbotEnabled() );
		$this->setField( $this->_ServerID,			$main_char->getServerID());
			
		$__CS->ExitMethod("loadFromModel:MemberNewForm");
	}
	
	/**
	 * 
	 *
	 * @access public
	 * @return string
	 */
	function getLogin()
	{
		return (string)$this->getFieldValue($this->_Login);
	}
	
	function getEMail()
	{
		return (string)$this->getFieldValue($this->_EMail);
	}
	
	function getRankID()
	{
		return (int)$this->getFieldValue($this->_RankID);
	}
	
	function getMainCharSex()
	{
		return (string)$this->getFieldValue($this->_MainCharSex);
	}
	
	function getMainCharName()
	{
		return (string)$this->getFieldValue($this->_MainCharName);
	}
	
	function getMainCharRaceID()
	{
		return (int)$this->getFieldValue($this->_MainCharRaceID);
	}
	
	function getMainCharClassID()
	{
		return (int)$this->getFieldValue($this->_MainCharClassID);
	}
	
	function getMainCharLevel()
	{
		return (int)$this->getFieldValue($this->_MainCharLevel);
	}
	
	function getMainCharEnableThottbot()
	{
		return (int)$this->getFieldValue($this->_EnableThottbot);
	}
	
	function getServerID()
	{
		return (int)$this->getFieldValue($this->_ServerID);
	}
}
?>