<?php
// AliasEditView.php
include( 'core/members/views/MemberView.php');


/**
 * 
 * @author Matthew Lindberg
 */
class AliasEditView extends MemberView
{
	// alias form
	var $alias_form;
	
	
	/**
	 * Constructor.
	 *
	 * @param $timer StopWatch
	 * @param $member_model MemberModel
	 * @param $alias_form AliasEditForm
	 * @access public
	 */
	function AliasEditView(& $timer, & $member_model, & $alias_form)
	{
		global $__CS;
		$__CS->EnterMethod("AliasEditView");
		$__CS->SendObject($timer,"timer");
		$__CS->SendObject($member_model,"member_model");
		$__CS->SendObject($member_form,"alias_form");
		
		// instantiate parent class
		parent::MemberView(& $timer, & $member_model);
		
		// Set all template variables
		
		$this->setTemplate("alias_edit.tpl");
		$this->alias_form =& $alias_form;
		$this->pagenum_from = NULL;
		
		$__CS->ExitMethod("AliasEditView");
	}
	
	/**
	 * Sets all the Smarty template variables for this View.
	 *
	 * @param $use_form_values boolean
	 * @access public
	 */
	function init()
	{
		global $__CS;
		$__CS->EnterMethod("init");
		
		parent::init();
		
		// Set module submenu
		$modulemenu = array(
							array("name" 	=> "search",
								"class" 	=> "off",
								"href"	=> $this->makeActionLink(__MEMBER,__MEMBER_SEARCH)
								 ),
							array("name"	=> "new",
								  "class"	=> "off",
								  "href"	=> $this->makeActionLink(__MEMBER,__MEMBER_NEW)
								));
		$this->tpl->assign( "modulemenu", $modulemenu );
		
		if($this->alias_form->isLoaded()) {
			$this->addToPageTitle("Edit Alias");
			$this->tpl->assign( "rightcolumntitle", "Edit Alias" );
			$this->tpl->assign( "formaction",      	$this->makeActionLink(__MEMBER,__MEMBER_ALIAS_UPDATE,array("memberid" => $this->model->getMemberID(),
																											   "aliasid" => $this->alias_form->getAliasID())));
			$this->tpl->assign( "aliasid", $this->alias_form->getAliasID());
			$this->tpl->assign( "backbuttonlink", $this->makeActionLink(__MEMBER,__MEMBER_EDIT,array("id" => $this->model->getMemberID(), "section" => "aliassection")));
		}
		else {
			$this->addToPageTitle("New Alias" );
			$this->tpl->assign( "rightcolumntitle", "New Alias" );
			$this->tpl->assign( "formaction", $this->makeActionLink(__MEMBER,__MEMBER_ALIAS_INSERT_NEW,array("memberid" => $this->model->getMemberID())));
			$this->tpl->assign( "backbuttonlink", $this->makeActionLink(__MEMBER,__MEMBER_EDIT,array("id" => $this->model->getMemberID(), "section" => "aliassection")));
		}
		
		
		list($ranks,$races,$classes,$levels,$characterpics,$servers) = $this->model->getCharacterOptions();
		
		$this->tpl->assign( "rankoptions",	$ranks );
		$this->tpl->assign( "raceoptions",	$races );
		$this->tpl->assign( "classoptions", $classes );
		$this->tpl->assign( "leveloptions", $levels );
		$this->tpl->assign( "characterpics",$characterpics );
		$this->tpl->assign( "serveroptions",$servers );
		
		$this->tpl->assign( "memberid",			$this->model->getMemberID());
		$this->tpl->assign( "sex",				$this->alias_form->getFormInput($this->alias_form->_Sex));
		$this->tpl->assign( "charactername", 	$this->alias_form->getFormInput($this->alias_form->_Name));
		$this->tpl->assign( "raceid",			$this->alias_form->getFormInput($this->alias_form->_RaceID));
		$this->tpl->assign( "classid",			$this->alias_form->getFormInput($this->alias_form->_ClassID));
		$this->tpl->assign( "level",			$this->alias_form->getFormInput($this->alias_form->_Level));
		$this->tpl->assign( "thottbot",			$this->alias_form->getFormInput($this->alias_form->_EnableThottbot));
		$this->tpl->assign( "serverid",			$this->alias_form->getFormInput($this->alias_form->_ServerID));
		
	
		$__CS->ExitMethod("init");
	}
	
	/**
	 *
	 * @access public
	 */
	function getBreadcrumbs()
	{
		global $__CS; 
		$__CS->EnterMethod("getBreadcrumbs");
		
		return parent::getBreadcrumbs()." - <a href=".__SITE_BASE_URL."index.php?".__MODULE."=deeds&".__ACTION."=new>New Deed</a>";
		
		$__CS->ExitMethod("getBreadcrumbs");
	}
}
?>