<?php
// MemberEditView.php
include( 'core/members/views/MemberView.php');


/**
 * 
 * @author Matthew Lindberg
 */
class MemberEditView extends MemberView
{
	// member form
	var $member_form;
	
	var $pagenum_from;
	
	var $display_section;
	
	/**
	 * Constructor.
	 *
	 * @param $timer StopWatch
	 * @param $member_model MemberModel
	 * @param $member_form MemberEditForm
	 * @access public
	 */
	function MemberEditView(& $timer, & $member_model, & $member_form)
	{
		global $__CS;
		$__CS->EnterMethod("MemberEditView ** Constructor");
		$__CS->SendObject($timer,"timer");
		$__CS->SendObject($member_model,"member_model");
		$__CS->SendObject($member_form,"member_form");
		
		// instantiate parent class
		parent::MemberView(& $timer, & $member_model);
		
		// Set all template variables
		
		$this->setTemplate("member_edit.tpl");
		$this->member_form =& $member_form;
		$this->pagenum_from = NULL;
		$this->display_section = NULL;
		
		$__CS->ExitMethod("MemberEditView ** Constructor");
	}
	
	/**
	 * Sets the page number that requested a new member edit.
	 *
	 * @param $page integer
	 * @access public
	 */
	function setPageFrom($page)
	{
		$this->pagenum_from = $page;
	}
	
	function setNoteForm(& $note_form)
	{
		$this->note_form =& $note_form;
	}
	
	/**
	 * Sets the section to be displayed first when the member edit view is loaded.
	 *
	 * @param $section string (mainsection,aliassection,deedlogsection,responsection,notesection)
	 * @access public
	 */
	function setDisplaySection($section)
	{
		$this->display_section = $section;
	}
	
	/**
	 * Sets all the Smarty template variables for this View.
	 *
	 * @param $use_form_values boolean
	 * @access public
	 */
	function init()
	{
		global $__CS;
		$__CS->EnterMethod("init");
		
		parent::init();
		
		// Set module submenu
		$modulemenu = array(
							array("name" 	=> "search",
								"class" 	=> "off",
								"href"	=> $this->makeActionLink(__MEMBER,__MEMBER_SEARCH)
								 ),
							array("name"	=> "new",
								  "class"	=> "off",
								  "href"	=> $this->makeActionLink(__MEMBER,__MEMBER_NEW)
								));
		$this->tpl->assign( "modulemenu", $modulemenu );
		
		$main_char =& $this->model->getMainCharacter();
		
		$member_id = $this->model->getMemberID();
		
		$this->tpl->assign( "memberid", $member_id );
		$this->addToPageTitle("Edit Member ".$main_char->getName());
		$this->tpl->assign( "rightcolumntitle", "Edit Member ".$main_char->getName() );
		$this->tpl->assign("javascript",  array(__DIR_ABS_JAVASCRIPT."toggleMultiDisplay.js",__DIR_ABS_JAVASCRIPT."confirmRequest.js") );
		if(!is_null($this->display_section)) {
			$this->tpl->assign("displaysection", $this->display_section);
		}
		if($this->pagenum_from != NULL) {
			$this->tpl->assign( "backbuttonlink", $this->makeActionLink(__MEMBER,__MEMBER_SEARCH,array("page" => $this->pagenum_from)));
		}
		else {
			$this->tpl->assign( "backbuttonlink", "nodisplay");
		}
		
		list($ranks,$races,$classes,$levels,$characterpics) = $this->model->getCharacterOptions();
		
		$this->tpl->assign( "rankoptions",	$ranks );
		$this->tpl->assign( "raceoptions",	$races );
		$this->tpl->assign( "classoptions", $classes );
		$this->tpl->assign( "leveloptions", $levels );
		$this->tpl->assign( "characterpics",$characterpics );
		
		
		
		
		// Assign all main section variables
		$main_section = array();
		$main_section["memberid"] 	= $this->member_form->getFormInput($this->member_form->_ID);
		$main_section["login"]    	= $this->member_form->getFormInput($this->member_form->_Login);
		$main_section["email"]		= $this->member_form->getFormInput($this->member_form->_EMail);
		$main_section["rankid"]		= $this->member_form->getFormInput($this->member_form->_RankID);
		$main_section["sex"]		= $this->member_form->getFormInput($this->member_form->_MainCharSex);
		$main_section["charactername"] = $this->member_form->getFormInput($this->member_form->_MainCharName);
		$main_section["raceid"]		= $this->member_form->getFormInput($this->member_form->_MainCharRaceID);
		$main_section["classid"]    = $this->member_form->getFormInput($this->member_form->_MainCharClassID);
		$main_section["level"]		= $this->member_form->getFormInput($this->member_form->_MainCharLevel);
		$main_section["thottbot"]	= $this->member_form->getFormInput($this->member_form->_EnableThottbot);
		$main_section["formaction"] = $this->makeActionLink(__MEMBER,__MEMBER_UPDATE,array("memberid"=>$member_id));
		
		
		
		
		// Assign all alias section variables
		$chars =& $this->model->getAliases();
		$all_chars = array();
		for($i=0; $i<count($chars); $i++) {
			$next_char = array();
			$alias_id = $chars[$i]->getCharacterID();
			$next_char["name"] 		= $chars[$i]->getName();
			$next_char["racename"] 	= $chars[$i]->getRace();
			$next_char["classname"]	= $chars[$i]->getClass();
			$next_char["level"]		= $chars[$i]->getLevel();
			$next_char["picfile"]	= $chars[$i]->getCharacterImg();
			$next_char["deletelink"] 	= $this->makeActionLink(__MEMBER,__MEMBER_ALIAS_DELETE,array("memberid" => $member_id, "aliasid" => $alias_id ));
			$next_char["editlink"]		= $this->makeActionLink(__MEMBER,__MEMBER_ALIAS_EDIT,array("memberid" => $member_id, "aliasid" => $alias_id ));
			$next_char["setasmainlink"]	= $this->makeActionLink(__MEMBER,__MEMBER_ALIAS_SETASMAIN,array("memberid" => $member_id, "aliasid" => $alias_id ));
			$all_chars[] = $next_char;
		}
		$alias_section = array();
		$alias_section["createaliaslink"] = $this->makeActionLink(__MEMBER,__MEMBER_ALIAS_NEW,array("memberid" => $member_id, "fromsection" => "PLACEHOLDER"));
		$alias_section["characters"] = $all_chars;
		
		
		
		
		// Assign all note section variables
		$notes =& $this->model->getNotes();
		$all_notes = array();
		for($i=0; $i<count($notes); $i++) {
			$next_note = array();
			$note_id = $notes[$i]->getNoteID();
			$next_note["datecreated"] 	= $notes[$i]->getDateCreated();
			$next_note["title"]			= $notes[$i]->getTitle();
			$next_note["readlink"]		= $this->makeActionLink(__MEMBER,__MEMBER_NOTE_POPUP, array("noteid"=>$note_id));
			$next_note["deletelink"]	= $this->makeActionLink(__MEMBER,__MEMBER_DELETE_NOTE,array("memberid" => $member_id, "noteid" => $note_id));
			
			$all_notes[] = $next_note;
		}
		$notes_section = array();
		$notes_section["notes"] = $all_notes;
		
		$form = array();
		$form["submitaction"] = $this->makeActionLink(__MEMBER,__MEMBER_INSERT_NOTE,array("memberid"=>$member_id));
		$form["title"] = $this->note_form->getFormInput($this->note_form->_Title);
		$form["note"] = $this->note_form->getFormInput($this->note_form->_Body);
		$notes_section["form"] = $form;
		
		
		
		
		// Assign all responsibility section variables
		list($member_respons,$rank_respons) = $this->model->getMemberResponsibilities();
		
		$all_member_respons = array();
		for($i=0; $i<count($member_respons); $i++) {
			$next_respon = array();
			$entry_id = $member_respons[$i]->getResponEntryID();
			$respon_id = $member_respons[$i]->getResponID();
			$next_respon["desc"]			= $member_respons[$i]->getResponName();
			$next_respon["detailslink"] 	= $this->makeActionLink(__RESPON,__RESPON_EDIT,array("id"=>$respon_id));
			$next_respon["markcompletelink"]= $this->makeActionLink(__MEMBER,__MEMBER_RESPON_MARKCOMPLETE,array("memberid" => $member_id, "entryid" => $entry_id));
			$next_respon["completebydate"]	= $member_respons[$i]->getCompleteByDate();
			$next_respon["overdue"]			= $member_respons[$i]->isOverdue();
			$all_member_respons[] = $next_respon;
		}
		$respon_section = array();
		$respon_section["chooseresponlink"] = $this->makeActionLink(__MEMBER,__MEMBER_SELECT_RESPONS, array("memberid"=>$member_id));
		$respon_section["memberrespon"] = $all_member_respons;
		
		$all_rank_respons = array();
		for($i=0; $i<count($rank_respons); $i++) {
			$next_respon = array();
			$entry_id = $rank_respons[$i]->getResponEntryID();
			$respon_id = $rank_respons[$i]->getResponID();
			$next_respon["desc"]			= $rank_respons[$i]->getResponName();
			$next_respon["detailslink"] 	= $this->makeActionLink(__RESPON,__RESPON_EDIT,array("id"=>$respon_id));
			$next_respon["markcompletelink"]= $this->makeActionLink(__MEMBER,__MEMBER_RESPON_MARKCOMPLETE,array("memberid" => $member_id, "entryid" => $entry_id));
			$next_respon["completebydate"]	= $rank_respons[$i]->getCompleteByDate();
			$next_respon["overdue"]			= $rank_respons[$i]->isOverdue();
			$all_rank_respons[] = $next_respon;
		}
		$respon_section["rankrespon"] = $all_rank_respons;
		
		
		
		// Assign all deed log section variables
		$deed_seq =& $this->model->getDeeds();
		$deed_log = array();
		$deed_log["adddeedslink"] = $this->makeActionLink(__MEMBER,__MEMBER_SELECT_DEEDLOG_DEEDS,array("memberid"=>$member_id));
		$deed_log["totalguilddp"] = $deed_seq->getDeedlogTotalGuildDP();
		$deed_log["totalquestdp"] = $deed_seq->getDeedlogTotalQuestDP();
		$deed_log["totalpvpdp"] = $deed_seq->getDeedlogTotalPvpDP();
		
		$all_deeds = array();
		while(!$deed_seq->pastEnd()) {
			$next_deed = array();
			$next_deed["desc"] 				= $deed_seq->getDeedName();
			$next_deed["timescompleted"] 	= $deed_seq->getNumTimes();
			$next_deed["deletelink"]		= $this->makeActionLink(__MEMBER,__MEMBER_DELETE_DEEDLOG_DEED,array("memberid"=>$member_id,"deedid"=>$deed_seq->getDeedID()));
			$next_deed["detailslink"]		= "details";
			$next_deed["guilddp"]			= $deed_seq->getGuildDP();
			$next_deed["questdp"]			= $deed_seq->getQuestDP();
			$next_deed["pvpdp"]				= $deed_seq->getPvpDP();
			$all_deeds[] = $next_deed;
			$deed_seq->forward();
		}
		$deed_log["deeds"] = $all_deeds;
		
		$all_sections = array();
		$all_sections["main"] 		= $main_section;
		$all_sections["aliases"] 	= $alias_section;
		$all_sections["notes"]		= $notes_section;
		$all_sections["responlist"]	= $respon_section;
		$all_sections["deedlog"]    = $deed_log;
		
		
		
		$this->tpl->assign("sections", $all_sections);
		$__CS->ExitMethod("init");
		
	}
	
	/**
	 *
	 * @access public
	 */
	function getBreadcrumbs()
	{
		global $__CS; 
		$__CS->EnterMethod("getBreadcrumbs");
		
		return parent::getBreadcrumbs()." - <a href=".__SITE_BASE_URL."index.php?".__MODULE."=deeds&".__ACTION."=new>New Deed</a>";
		
		$__CS->ExitMethod("getBreadcrumbs");
	}
}