<?php
// MemberNewView.php
include( 'core/members/views/MemberView.php');


/**
 * 
 * @author Matthew Lindberg
 */
class MemberNewView extends MemberView
{
	// member form
	var $member_form;
	
	var $pagenum_from;
	
	/**
	 * Constructor.
	 *
	 * @param $timer StopWatch
	 * @param $member_model MemberModel
	 * @param $member_form MemberForm
	 * @access public
	 */
	function MemberNewView(& $timer, & $member_model, & $member_form)
	{
		global $__CS;
		$__CS->EnterMethod("MemberNewView");
		$__CS->SendObject($timer,"timer");
		$__CS->SendObject($member_model,"member_model");
		$__CS->SendObject($member_form,"member_form");
		
		// instantiate parent class
		parent::MemberView(& $timer, & $member_model);
		
		// Set all template variables
		
		$this->setTemplate("member_new.tpl");
		$this->member_form =& $member_form;
		$this->pagenum_from = NULL;
		
		$__CS->ExitMethod("MemberNewView");
	}
	
	/**
	 * Sets the page number that requested a new member edit.
	 *
	 * @param $page integer
	 * @access public
	 */
	function setPageFrom($page)
	{
		$this->pagenum_from = $page;
	}
	
	/**
	 * Sets all the Smarty template variables for this View.
	 *
	 * @param $use_form_values boolean
	 * @access public
	 */
	function init()
	{
		global $__CS;
		$__CS->EnterMethod("init");
		
		parent::init();
		
		// Set module submenu
		$modulemenu = array(
							array("name" 	=> "search",
								"class" 	=> "off",
								"href"	=> $this->makeActionLink(__MEMBER,__MEMBER_SEARCH)
								 ),
							array("name"	=> "new",
								  "class"	=> "on",
								  "href"	=> $this->makeActionLink(__MEMBER,__MEMBER_NEW)
								));
		$this->tpl->assign( "modulemenu", $modulemenu );
		
		$this->addToPageTitle("Create New Member");
		$this->tpl->assign( "rightcolumntitle", "Create New Member" );
		$this->tpl->assign( "formaction",      	$this->makeActionLink(__MEMBER,__MEMBER_INSERT_NEW));
		$this->tpl->assign( "backbuttonlink", $this->makeActionLink(__MEMBER,__MEMBER_SEARCH,array("page" => $this->pagenum_from)));
			
		list($ranks,$races,$classes,$levels,$characterpics,$servers) = $this->model->getCharacterOptions();
		
		$this->tpl->assign( "rankoptions",	$ranks );
		$this->tpl->assign( "raceoptions",	$races );
		$this->tpl->assign( "classoptions", $classes );
		$this->tpl->assign( "leveloptions", $levels );
		$this->tpl->assign( "characterpics",$characterpics );
		$this->tpl->assign( "serveroptions",$servers );
		
		$this->tpl->assign( "memberid",	 		$this->member_form->getFormInput($this->member_form->_ID));
		$this->tpl->assign( "login",			$this->member_form->getFormInput($this->member_form->_Login));
		$this->tpl->assign( "email",			$this->member_form->getFormInput($this->member_form->_EMail));
		$this->tpl->assign( "rankid",			$this->member_form->getFormInput($this->member_form->_RankID));
		$this->tpl->assign( "sex",				$this->member_form->getFormInput($this->member_form->_MainCharSex));
		$this->tpl->assign( "charactername", 	$this->member_form->getFormInput($this->member_form->_MainCharName));
		$this->tpl->assign( "raceid",			$this->member_form->getFormInput($this->member_form->_MainCharRaceID));
		$this->tpl->assign( "classid",			$this->member_form->getFormInput($this->member_form->_MainCharClassID));
		$this->tpl->assign( "level",			$this->member_form->getFormInput($this->member_form->_MainCharLevel));
		$this->tpl->assign( "thottbot",			$this->member_form->getFormInput($this->member_form->_EnableThottbot));
		$this->tpl->assign( "serverid",			$this->member_form->getFormInput($this->member_form->_ServerID));
		
	
		$__CS->ExitMethod("init");
	}
	
	/**
	 *
	 * @access public
	 */
	function getBreadcrumbs()
	{
		global $__CS; 
		$__CS->EnterMethod("getBreadcrumbs");
		
		return parent::getBreadcrumbs()." - <a href=".__SITE_BASE_URL."index.php?".__MODULE."=deeds&".__ACTION."=new>New Deed</a>";
		
		$__CS->ExitMethod("getBreadcrumbs");
	}
}
?>