<?php
// ResponsibilitySelectView.php
include( 'core/members/views/MemberView.php');

/**
 * 
 * @author Matthew Lindberg
 */
class ResponsibilitySelectView extends MemberView
{
	// responsibility select list form
	var $respon_select_form;
	
	// integer
	var $pagenum_from;
	
	
	// member identifier
	var $member_id;
	
	// respon model
	var $respon_model;
	
	
	/**
	 * Constructor.
	 *
	 * @param $timer StopWatch
	 * @param $member_model MemberModel
	 * @param $member_form MemberEditForm
	 * @access public
	 */
	function ResponsibilitySelectView(& $timer, & $member_model)
	{
		// instantiate parent class
		parent::MemberView(& $timer, & $member_model);
		
		// Set all template variables
		$this->setTemplate("responsibility_select_list.tpl");
		$this->respon_select_form 	= NULL;
		$this->respon_model			= NULL;
		$this->member_id			= NULL;
		$this->pagenum_from 		= NULL;
	}
	
	/**
	 *
	 * @access public
	 */
	function setSelectForm(& $respon_select_form)
	{
		$this->respon_select_form =& $respon_select_form;
	}
	
	/**
	 *
	 * @access public
	 */
	function setResponsibilityModel(& $respon_model)
	{
		$this->respon_model =& $respon_model;
	}
	
	/**
	 *
	 * @param $page integer
	 * @access public
	 */
	function setPageFrom($page)
	{
		$this->pagenum_from = $page;
	}
	
	/**
	 *
	 * @access public
	 */
	function setMemberID($member_id)
	{
		$this->member_id = $member_id;
	}
	
	
	/**
	 * Sets all the Smarty template variables for this View.
	 *
	 * @param $use_form_values boolean
	 * @access public
	 */
	function init()
	{
		global $__CS;
		$__CS->EnterMethod("init");
		
		if($this->respon_select_form == NULL) {
			die("Error rendering ResponsibilitySelectView.  Responsibility select form must be set.");
		}
		parent::init();
		
		// Set module submenu
		$modulemenu = array(
							array("name" 	=> "search",
								"class" 	=> "off",
								"href"	=> $this->makeActionLink(__MEMBER,__MEMBER_SEARCH)
								 ),
							array("name"	=> "new",
								  "class"	=> "off",
								  "href"	=> $this->makeActionLink(__MEMBER,__MEMBER_NEW)
								));
		$this->tpl->assign( "modulemenu", $modulemenu );
		$this->tpl->assign( "memberid", $member_id );
		$this->addToPageTitle("Select Member Responsibilities");
		$this->tpl->assign( "rightcolumntitle", "Select Member Responsibilities");
		$this->tpl->assign("javascript",  array(__DIR_ABS_JAVASCRIPT."toggleMultiDisplay.js",__DIR_ABS_JAVASCRIPT."confirmRequest.js") );
		$this->tpl->assign( "backbuttonlink", $this->makeActionLink(__MEMBER,__MEMBER_EDIT,array("id"=>$this->member_id, "section"=>"responsection")));
		$this->tpl->assign( "checkboxname", "responid" );
		$this->tpl->assign( "numoftimesname", "numoftimes");
		$this->tpl->assign( "formaction", $this->makeActionLink(__MEMBER,__MEMBER_INSERT_RESPONS,array("memberid"=>$this->member_id)));
		$this->tpl->assign( "numoftimesoptions", array( "1"=>"1", "2"=>"2", "3"=>"3", "4"=>"4", "5"=>"5", "6"=>"6" ));
		
		
		// Get all current member responsibilities
		list($member_respons)= $this->model->getMemberResponsibilities();
		$respon_list = array();
		for($i=0; $i<count($member_respons); $i++) {
			$respon_list[$member_respons[$i]->getResponID()] =& $member_respons[$i];
		}
		
		$respons = array();
		$respon_coll =& $this->respon_model->selectAll();
		$respon_iter =& $respon_coll->createIterator();
		while(!$respon_iter->isDone()) {
			$next_respon = array();
			$row =& $respon_iter->fetch();
			$this->respon_model->loadFromDBRow(& $row);
			
			$next_respon["responid"] = $this->respon_model->getResponID();
			$next_respon["respondesc"] = $this->respon_model->getResponName();
			$next_respon["detailslink"] = $this->makeActionLink(__RESPON,__RESPON_DETAILS_POPUP,array("responid"=>$next_respon["responid"]));
			
			if(array_key_exists($next_respon["responid"],$respon_list)) {
				$next_respon["checked"] = "yes";
				$next_respon["completetime"] = $respon_list[$next_respon["responid"]]->getFinishInCount();
				$next_respon["completetimetype"] = $respon_list[$next_respon["responid"]]->getFinishInType();
			}
			else {
				$next_respon["checked"] = "no";
				$next_respon["completetime"] = 1;
				$next_respon["completetimetype"] = "day";
			}
			$respons[] = $next_respon;
		}
		$this->tpl->assign( "respon", $respons);
		$this->tpl->assign( "completetimeoptions", array( "1"=>"1", "2"=>"2", "3"=>"3", "4"=>"4", "5"=>"5", "6"=>"6" ));
		$this->tpl->assign( "completetimetypeoptions", array( "day"=>"day","month"=>"month","year"=>"year" ));
		$this->tpl->assign("owneridname","ownerid");
		$this->tpl->assign("completetimename", "completetimevalue");
		$this->tpl->assign("completetimetypename", "completetimetype");
		$this->tpl->assign("ownerid",$this->member_id);
		
		$__CS->ExitMethod("init");
	}
	
	/**
	 *
	 * @access public
	 */
	function getBreadcrumbs()
	{
		global $__CS; 
		$__CS->EnterMethod("getBreadcrumbs");
		
		return parent::getBreadcrumbs()." - <a href=".__SITE_BASE_URL."index.php?".__MODULE."=deeds&".__ACTION."=new>New Deed</a>";
		
		$__CS->ExitMethod("getBreadcrumbs");
	}
}
/*
$smarty->assign( "ownerid",33 );
$smarty->assign( "owneridname","rankid" );
$smarty->assign( "ownertype", "rank" );
$smarty->assign( "backbuttonlink", "http://goback" );
$smarty->assign( "checkboxname", "respons" );
$smarty->assign( "completetimename", "completetime" );
$smarty->assign( "formaction", "http://formaction" );
$smarty->assign( "respon", array(
									array( 	"responid" => 3,
											"respondesc" => "Recruit 3 new members",
											"checked" => "yes",
											"detailslink" => "href://details",
											"completetime" => 2,
											"completetimetype" => "day"
										 ),
									array(	"responid" => 4,
											"respondesc" => "Recruit 3 new members",
											"checked" => "yes",
											"detailslink" => "href://details",
											"completetime" => 5,
											"completetimetype" => "month"
										 ),
									array(	"responid" => 3,
											"respondesc" => "Recruit 3 new members",
											"checked" => "yes",
											"detailslink" => "href://details",
											"completetime" => 2,
											"completetimetype" => "year"
										 )
								));
$smarty->assign( "completetimeoptions", array( "1"=>"1", "2"=>"2", "3"=>"3", "4"=>"4", "5"=>"5", "6"=>"6" ));
$smarty->assign( "completetimetypeoptions", array( "day"=>"day","month"=>"month","year"=>"year" ));
*/
?>