<?php
// RankModel.php
include_once('core/base/Model.php');

/**
 * The logical model for all rank operations.
 *
 * @author Matthew Lindberg
 */
class RankModel extends Model
{
	var $_RankTableName 		= "Rank";
	// deed table fields
	var $_RankID				= "i_rankID";
	var $_SubordinateID			= "i_subordinateID";
	var $_SuperiorID			= "i_superiorID";
	var $_PromoRequirementsID 	= "i_promoRequirementsID";
	var $_RankName 				= "vch_rankName";
	
	var $_PromoRequireTableName = "PromotionRequirements";
	// promotion requirements table fields
	var $_PromoRequireID   		= "i_promoRequirementsID";
	var $_PromoGuildDeedPoints	= "i_guildDeedPoints";
	var $_PromoQuestDeedPoints 	= "i_questDeedPoints";
	var $_PromoPvpDeedPoints	= "i_pvpDeedPoints";
	
	
	
	
	
	/**
	 * Constructor.
	 *
	 * @param $data_access DataAccess
	 * @access public
	 */
	function RankModel(& $data_access)
	{
		global $__CS;
		$__CS->EnterMethod("RankModel");
		$__CS->SendObject($data_access,"data_access");
		
		parent::Model(& $data_access);
		$this->init();
		
		$__CS->ExitMethod("DeedModel");
	}
	
	/**
	 * Loads all default values for this model.
	 *
	 * @access public
	 */
	function init()
	{
		global $__CS;
		$__CS->EnterMethod("init");
		
		$this->setData( $this->_DeedTableName,	$this->_DeedID,  		NULL );
		$this->setData( $this->_DeedTableName,	$this->_DeedName,  		NULL );
		$this->setData( $this->_DeedTableName,	$this->_DeedDesc,  		NULL );
		$this->setData(	$this->_DeedTableName,	$this->_MultiComplete, 	NULL );
		$this->setData( $this->_DeedTableName, 	$this->_Difficulty,	 	NULL );
		$this->setData( $this->_DeedTableName,	$this->_GPGuild,  		NULL );
		$this->setData( $this->_DeedTableName,	$this->_GPPvp,			NULL );
		$this->setData( $this->_DeedTableName,	$this->_GPQuest,		NULL );
					
		$this->setLoaded(false);	
		$this->setSaved(true);
		$this->setExisting(false);
		
		$__CS->ExitMethod("init");
	}
	
	/**
	 * Saves the model data into the database.
	 *
	 * @access public
	 */
	function save()
	{	
		global $__CS;
		$__CS->EnterMethod("save");
		
		if( !$this->isLoaded() ) {
			return false;
		}
		else if( $this->isSaved() ) {
			return false;
		}
		else if( $this->isExisting() ) {
			$this->_saveByUpdate();
		}
		else {
			$this->_saveByInsert();
		}
		
		$__CS->ExitMethod("save");
		return true;
	}

	
	/**
	 *
	 */
	function _saveByUpdate()
	{
		global $__CS;
		$__CS->EnterMethod("_saveByUpdate");
		
		$sb =& $this->da->getStatementBuilderInstance();
		$sb->clear();
		$sb->addUpdate($this->_DeedTableName, $this->_DeedName,		$this->getDataValue( $this->_DeedTableName, $this->_DeedName));
		$sb->addUpdate($this->_DeedTableName, $this->_DeedDesc, 	$this->getDataValue( $this->_DeedTableName, $this->_DeedDesc));
		$sb->addUpdate($this->_DeedTableName, $this->_MultiComplete,$this->getDataValue( $this->_DeedTableName, $this->_MultiComplete));
		$sb->addUpdate($this->_DeedTableName, $this->_Difficulty,	$this->getDataValue( $this->_DeedTableName, $this->_Difficulty));
		$sb->addUpdate($this->_DeedTableName, $this->_GPGuild,		$this->getDataValue( $this->_DeedTableName, $this->_GPGuild));
		$sb->addUpdate($this->_DeedTableName, $this->_GPQuest,		$this->getDataValue( $this->_DeedTableName, $this->_GPQuest));
		$sb->addUpdate($this->_DeedTableName, $this->_GPPvp,		$this->getDataValue( $this->_DeedTableName, $this->_GPPvp));
		$sb->addConstraint($this->_DeedTableName, $this->_DeedID, "=", $this->getDataValue( $this->_DeedTableName, $this->_DeedID ));
		
		$sql = $sb->getUpdateSQL();
		$this->da->update($sql[0]);
		if( $this->da->isError() ) {
			trigger_error(mysql_error());
		}
		
		$this->setSaved(true);
		
		$__CS->ExitMethod("_saveByUpdate");
	}
	
	/**
	 *
	 */
	function _saveByInsert()
	{
		global $__CS;
		$__CS->EnterMethod("_saveByInsert");
		
		$sb =& $this->da->getStatementBuilderInstance();
		$sb->clear();
		$sb->addInsert($this->_DeedTableName, $this->_DeedID, 		$this->getDataValue( $this->_DeedTableName, $this->_DeedID));
		$sb->addInsert($this->_DeedTableName, $this->_DeedName,		$this->getDataValue( $this->_DeedTableName, $this->_DeedName));
		$sb->addInsert($this->_DeedTableName, $this->_DeedDesc, 	$this->getDataValue( $this->_DeedTableName, $this->_DeedDesc));
		$sb->addInsert($this->_DeedTableName, $this->_MultiComplete,$this->getDataValue( $this->_DeedTableName, $this->_MultiComplete));
		$sb->addInsert($this->_DeedTableName, $this->_Difficulty,	$this->getDataValue( $this->_DeedTableName, $this->_Difficulty));
		$sb->addInsert($this->_DeedTableName, $this->_GPGuild,		$this->getDataValue( $this->_DeedTableName, $this->_GPGuild));
		$sb->addInsert($this->_DeedTableName, $this->_GPQuest,		$this->getDataValue( $this->_DeedTableName, $this->_GPQuest));
		$sb->addInsert($this->_DeedTableName, $this->_GPPvp,		$this->getDataValue( $this->_DeedTableName, $this->_GPPvp));
		
		$sql = $sb->getInsertSQL();
		$id = $this->da->update($sql[0]);
		if( $this->da->isError() ) {
			trigger_error(mysql_error());
		}
		
		$this->setData( $this->_DeedID, $this->_DeedTableName, $id );
		
		$this->setSaved(true);
		$this->setExisting(true);
		
		$__CS->ExitMethod("_saveByInsert");
	}
	
	
	/**
	 *
	 * @param $form DeedForm
	 * @access public
	 */
	function loadFromForm(& $form )
	{
		global $__CS;
		$__CS->EnterMethod("loadFromForm");
		$__CS->SendObject($form,"form");
		
		if( $form->getExisting() != 0 ) {
			$this->setExisting(true);
			$this->setData( $this->_DeedID,	$this->_DeedTableName, $form->getDeedID() );
		}
		else {
			$this->setExisting(false);
		}
		$this->setData( $this->_DeedTableName,	$this->_DeedID,			$form->getDeedID() );
		$this->setData( $this->_DeedTableName,	$this->_DeedName,	 	$form->getDeedName() );
		$this->setData( $this->_DeedTableName,	$this->_DeedDesc,		$form->getDeedDesc() );
		$this->setData( $this->_DeedTableName,	$this->_MultiComplete,	$form->getMultiCompletion() );
		$this->setData( $this->_DeedTableName,	$this->_Difficulty,		$form->getDifficulty() );
		$this->setData( $this->_DeedTableName,	$this->_GPGuild,		$form->getGuildGP() );
		$this->setData( $this->_DeedTableName,	$this->_GPPvp,			$form->getPvpGP() );
		$this->setData( $this->_DeedTableName,	$this->_GPQuest,		$form->getQuestGP() );
		
		$this->setLoaded(true);
		$this->setSaved(false);
		
		$__CS->ExitMethod("loadFromForm");
	}
	
	/**
	 * Loads the deed model with the deed matching the deedID.
	 *
	 * @param $deedID integer
	 * @access public
	 */
	function loadFromID( $deedID )
	{
		global $__CS;
		$__CS->EnterMethod("loadFromID");
		$__CS->SendVar($deedID,"deedID");
		
		$sb =& $this->da->getStatementBuilderInstance();
		$sb->addSelect( $this->_DeedTableName, array($this->_DeedID,$this->_DeedName,$this->_DeedDesc,
													 $this->_MultiComplete, $this->_Difficulty, $this->_GPGuild,
													 $this->_GPPvp, $this->_GPQuest));
		$sb->addConstraint( $this->_DeedTableName, $this->_DeedID, "=", $deedID );
		$sql = $sb->getSingleSelectSQL(false);
		$sb->clear();
		
		$result =& $this->da->query($sql);
		
		if( ($count = count($result)) != 1 ) {
			$__CS->ExitMethod("loadFromID");
			return false;
		}
		// Grab the DBRow result object
		$row =& $result[0];
		
		$this->loadFromDBRow(& $row);
		
		$__CS->ExitMethod("loadFromID");
		return true;
	}
	
	/**
	 * Loads the deed model using a DBRow object filled with the correct
	 * fields.
	 *
	 * @param $dbrow DBRow
	 * @access public
	 * @return void
	 */
	function loadFromDBRow( & $dbrow )
	{
		global $__CS;
		$__CS->EnterMethod("loadFromDBRow");
		$__CS->SendObject($dbrow,"dbrow");
		
		$this->setData( $this->_DeedTableName, $this->_DeedID, 			$dbrow->getValue($this->_DeedID));
		$this->setData( $this->_DeedTableName, $this->_DeedName,		$dbrow->getValue($this->_DeedName));
		$this->setData( $this->_DeedTableName, $this->_DeedDesc,		$dbrow->getValue($this->_DeedDesc));
		$this->setData( $this->_DeedTableName, $this->_MultiComplete,	$dbrow->getValue($this->_MultiComplete));
		$this->setData( $this->_DeedTableName, $this->_Difficulty,		$dbrow->getValue($this->_Difficulty));
		$this->setData( $this->_DeedTableName, $this->_GPGuild,			$dbrow->getValue($this->_GPGuild));
		$this->setData( $this->_DeedTableName, $this->_GPPvp,			$dbrow->getValue($this->_GPPvp));
		$this->setData( $this->_DeedTableName, $this->_GPQuest,			$dbrow->getValue($this->_GPQuest));
		
		$this->setLoaded(true);
		$this->setSaved(true);
		$this->setExisting(true);
		
		$__CS->ExitMethod("loadFromDBRow");
	}
	
	
	
	
	/**
	 * Finds all deeds from start_index to __MAX_DEED_RESULTS.
	 *
	 * @param $start_index integer
	 * @access public
	 * @return array( <DBRowCollection>, <total count> )
	 */
	function & searchAll($start_index=0)
	{
		global $__CS;
		$__CS->EnterMethod("searchAll");
		$__CS->SendVar($start_index,"start_index");
		
		
		$sb =& $this->da->getStatementBuilderInstance();
		$sb->addSelect($this->_DeedTableName,array("*"));
		
		$sql_count  = $sb->getSingleSelectSQL(true);
		$sql_select = $sb->getSingleSelectSQL(false, array($start_index,__MAX_DEED_RESULTS));
		$sb->clear();
		
		$__CS->SendSQL($sql_count);
		$__CS->SendSQL($sql_select);
	 	
		// First, check that the start index doesn't exceed the total number of items in the database
		$result_arr = $this->da->query($sql_count);
		
		$count_result =& $result_arr[0];
		$count = $count_result->getValue("rowcount");
		if($start_index > $count) {
			trigger_error(__ERROR."Start index $start_index exceeds total result count in DeedModel:searchAll()" );
		}
		
		// Now, select the result collection
		$collection =& $this->da->fetchCollection($sql_select);
		$__CS->SendObject($collection,"collection");
		
		return array(& $collection, $count);
		$__CS->ExitMethod("searchAll");
	}
	
	 
	 
	/**
	 * 
	 * @access public
	 */
	function getDeedID()
	{
		return (int)$this->getDataValue($this->_DeedTableName, $this->_DeedID );
	}
	
	/**
	 * 
	 * @access public
	 */
	function getDeedName()
	{
		return (string)$this->getDataValue($this->_DeedTableName,$this->_DeedName);
	}
	
	/**
	 * 
	 * @access public
	 */
	function getDeedDesc()
	{
		return (string)$this->getDataValue($this->_DeedTableName,$this->_DeedDesc);
	}
	
	/**
	 * 
	 * @access public
	 */
	function getMultiCompletion()
	{
		return (int)$this->getDataValue($this->_DeedTableName,$this->_MultiComplete);
	}
	
	/**
	 * 
	 * @access public
	 */
	function getDifficulty()
	{
		return (string)$this->getDataValue($this->_DeedTableName,$this->_Difficulty);
	}
	
	/**
	 * 
	 * @access public
	 */
	function getGuildGP()
	{
		return (int)$this->getDataValue($this->_DeedTableName,$this->_GPGuild);
	}
	
	/**
	 * 
	 * @access public
	 */
	function getQuestGP()
	{
		return (int)$this->getDataValue($this->_DeedTableName,$this->_GPQuest);
	}
	
	/**
	 * 
	 * @access public
	 */
	function getPvpGP()
	{
		return (int)$this->getDataValue($this->_DeedTableName,$this->_GPPvp);
	}
}
?>