<?php
// RankLadderView.php
include( 'core/ranks/views/RankView.php');


/**
 * The rank ladder view.  Displays a ladder hierarchy of existing ranks and the promotion paths between ranks.   
 *
 * @author Matthew Lindberg
 *
 * @todo template var linkdetail doesn't do anything at this point.  If detail page is necessary, add it.
 */
class RankLadderView extends RankView
{
	
	/**
	 * Constructor.
	 *
	 * @param $timer StopWatch
	 * @param $rank_model RankModel
	 * @access public
	 */
	function RankLadderView(& $timer, & $rank_model)
	{
		global $__CS;
		$__CS->EnterMethod("RankLadderView");
		$__CS->SendObject($timer,"timer");
		$__CS->SendObject($rank_model,"rank_model");
		
		// instantiate parent class
		parent::RankView(& $timer, & $rank_model);
		
		// Set all template variables
		$this->addToPageTitle("Rank Ladder");
		$this->setTemplate("rank_ladder.tpl");
		
		$__CS->ExitMethod("RankLadderView");
	}
	
	
	/**
	 * Initializes all the Smarty template variables for this View.
	 *
	 * @access private
	 */
	function init()
	{
		global $__CS;
		parent::init();
				   
		$this->tpl->assign( "rightcolumntitle", "Rank Ladder" );
		$this->tpl->assign( "javascript", array(__DIR_ABS_JAVASCRIPT."toggleMultiDisplay.js") );
		
		$this->tpl->assign( "totalmembers", 33 );
		$this->tpl->assign( "ladder",
		array(
			array( 	"displayid" => "Officer",
				"rankname" => "Officer",
				"rankmembers" => array(  
								array(	"membername" => "Cronix",
									"memberid"	=> 33,
									"memberclass" => "Warlock",
									"demotelink" => "http://demote",
									"editlink" => "http://edit"),
								array( "membername" => "Cronfel",
									"memberid" => 66,
									"memberclass" => "Mage",
									"demotelink" => "http://demote",
									"editlink" => "http://edit")
							),
				"rankresponsibilitylist" => array(
									array( 	"respontext" => "Do this, do that",
										"responid"  => 443,
										"removelink" => "http://removeresponsibility",
										"detailslink" => "http://detailresponsibility",
										"intervalvalue" => 4,
										"intervaltype" => "days")
								)
				),
			array( "displayid" => "PeonToOfficer",
				"promopathdeedlist" => array(
									array( "deeddesc" => "Go do the deed dude.",
									          "detailslink" => "http://deeddetails"),
									array( "deeddesc" => "The dirty deed.",
									          "detailslink" => "http://deeddetails")
							          ),
				"deedpointseditlink" => "http://editdeedpointslist",
				"guilddeedpoints" => 300,
				"questdeedpoints" => 450,
				"pvpdeedpoints" => 770,
				"promopathmembers" => array(
									array( "membername" => "Thorvalon",
									          "memberid" => 47,
									          "memberclass" => "Priest",
									          "promotelink" => "http://promote",
									          "editlink" => "http://edit" ),
									array( "membername" => "The Dude",
									          "memberid" => 59,
									          "memberclass" => "Dudevader",
									          "promotelink" => "http://promote",
									          "editlink" => "http://edit")
								)
			       ),
			array( 	"displayid" => "Peon",
				"rankname" => "Peon")
		));
$this->tpl->assign( "deletelink", "http://deleterank" );
$this->tpl->assign( "rankresponsibilitylisteditlink", "http://editresponsibilitylist" );
$this->tpl->assign("promopathdeedlisteditlink", "http://editdeedlist" );
	}
	
	/**
	 *
	 * @access public
	 */
	function getBreadcrumbs()
	{
		global $__CS; 
		$__CS->EnterMethod("getBreadcrumbs");
		
		return parent::getBreadcrumbs()." - <a href=".__SITE_BASE_URL."index.php?".__MODULE."=".__RANK."&".__ACTION."=".__RANK_LADDER.">Rank Ladder</a>";
		
		$__CS->ExitMethod("getBreadcrumbs");
	}
}


?>