<?php
// DeleteResponsibility.php
include_once('core/base/Action.php');

/**
 * Deletes a responsibility matching a responsibility id.
 * 
 *
 * @author Matthew Lindberg
 */
class DeleteResponsibility extends Action
{
	
	/**
	 * Executes action.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS;
		$__CS->EnterMethod("execute:DeleteResponsibility");
		
		$request	=& $context->getEntry(__REQUEST);
		$model		=& $context->getEntry(__MODEL);
		
		$id = $request->get("id");
		
		if( !$model->delete($id) ) {
			trigger_error(__ERROR."Could not delete responsibilty in execute:DeleteResponsibility");
			$__CS->ExitMethod("execute");
			return false;
		}
		
		$request->addFeedback("Responsibility #".$id." has been deleted");
		
		// Now, redirect control to the deed search view
		$request->set(__ACTION,__RESPON_SEARCH);
		$controller  =& $context->getEntry(__CONTROLLER);
		$controller->processRequest(& $request);
		
		$__CS->ExitMethod("execute:DeleteResponsibility");
		return false;
	}
}
?>