<?php
// InsertNewResponsibility.php
include_once('core/base/Action.php');

/**
 * Inserts a new responsibility into the database based on responsibility form input.
 * 
 * Set view to a new blank deed form on success, or an error view on failure.
 *
 * @author Matthew Lindberg
 */
class InsertNewResponsibility extends Action
{
	/**
	 * 
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS;
		$__CS->EnterMethod("execute:InsertNewResponsibility");
		
		$session 	=& $context->getEntry(__SESSION);
		$request	=& $context->getEntry(__REQUEST);
		$timer		=& $context->getEntry(__TIMER);
		
		include_once('core/responsibilities/forms/ResponsibilityForm.php');
		$respon_form =& new ResponsibilityForm(& $session, & $request);
		$respon_form->loadFromRequest();
		
		$model 		=& $context->getEntry(__MODEL);
		$model->loadFromForm( & $respon_form );
		
		if( !$model->save() ) {
			trigger_error(__ERROR."Could not save responsibility in execute:InsertNewResponsibility");
			$__CS->ExitMethod("execute:InsertNewResponsibility");
			return false;
		}
		$request->addFeedback("new responsibility has been successfully created");
		
		$respon_form->init(); // clear the form
		
		include_once('core/responsibilities/views/ResponsibilityEditView.php');
		$view 	=& new ResponsibilityEditView(& $timer, & $model, & $respon_form);
		$view->addFeedback($request->getFeedback());
		$view->setPageFrom($request->get("pageback"));
		$view->init();
		
		$controller  =& $context->getEntry(__CONTROLLER);
		$controller->setView( & $view );
		$__CS->ExitMethod("execute:InsertNewResponsibility");
		return true;
	}
}
?>