<?php
// ResponsibilityForm.php
include_once('core/base/Form.php');

/**
 * Form for creation and editing of responsibilities.
 *
 * @author Matthew Lindberg
 */
class ResponsibilityForm extends Form
{
	var $_EditExisting	= "editexisting";
	var $_ResponID		= "responid";
	var $_ResponName	= "responname";
	var $_ResponDesc	= "respondesc";
	
	
	
	/**
	 * Constructor.
	 *
	 * @access public
	 */
	function ResponsibilityForm(& $session, & $request)
	{
		global $__CS; 
		$__CS->EnterMethod("ResponsibilityForm ** Constructor");
		$__CS->SendObject($session,"session");
		$__CS->SendObject($request,"request");
		
		parent::Form(& $session, & $request);
		$this->init();
		
		$__CS->ExitMethod("ResponsibilityForm ** Constructor");
	}

	/**
	 * Sets all of the default values for this form.
	 *
	 * @access public
	 */
	function init()
	{
		global $__CS; 
		$__CS->EnterMethod("setDefaultValues");
		
		$this->setField($this->_EditExisting,	0);
		$this->setField($this->_ResponID,		NULL);
		$this->setField($this->_ResponName,		"");	
		$this->setField($this->_ResponDesc,		"");
		
		$__CS->ExitMethod("setDefaultValues");	
	}
	
	/**
	 * Loads the form with a ResponsibilityModel.
	 *
	 * @param $model
	 * @access public
	 */
	function loadFromModel(& $model)
	{
		global $__CS; 
		$__CS->EnterMethod("loadFromModel:ResponsibilityForm");
		$__CS->SendObject($model,"model");
		
		( $model->isExisting() )
		? $this->setField($this->_EditExisting,1)
		: $this->setField($this->_EditExisting,0);
		
		$this->setField( $this->_ResponID, 		$model->getResponID() );
		$this->setField( $this->_ResponName, 	$model->getResponName() );
		$this->setField( $this->_ResponDesc,	$model->getResponDesc() );
		
		$__CS->ExitMethod("loadFromModel:ResponsibilityForm");
	}
	
	/**
	 * Gets the deed existing status of the form.
	 *
	 * @access public
	 * @return integer 0 if form data doesn't exist in database, 1 if it does
	 */
	function getExisting()
	{
		global $__CS; 
		$__CS->EnterMethod("getExisting");
		
		$value = (int)$this->getFieldValue($this->_EditExisting);
		
		$__CS->ExitMethod("getExisting");
		return $value;
	}
	
	/**
	 * Gets the responsibility id from the form, or NULL if it is a blank form.
	 *
	 * @access public
	 * @return integer or null 
	 */
	function getResponID()
	{
		global $__CS; 
		$__CS->EnterMethod("getResponID:ResponsibilityForm");
		
		$value = (int)$this->getFieldValue($this->_ResponID);
		
		$__CS->ExitMethod("getResponID:ResponsibilityForm");
		return $value;
	}
	
	/**
	 * Gets the name of the responsibility.
	 *
	 * @access public
	 * @return string
	 */
	function getResponName()
	{
		global $__CS; 
		$__CS->EnterMethod("getResponName:ResponsibilityForm");
		
		$value = (string)$this->getFieldValue($this->_ResponName);
		
		$__CS->ExitMethod("getResponName:ResponsibilityForm");
		return $value;
	}
	
	/**
	 * Gets the full responsibility description.
	 *
	 * @access public
	 * @return string
	 */
	function getResponDesc()
	{
		global $__CS; 
		$__CS->EnterMethod("getResponDesc:ResponsibilityForm");
		
		$value = (string)$this->getFieldValue($this->_ResponDesc);
		
		$__CS->ExitMethod("getResponDesc:ResponsibilityForm");
		return $value;
	}
	
	
	

}
?>