<?php
// ResponsibilityView.php
include('core/base/View.php');

/** 
 * The Parent class for all ResponsibilityViews.
 *
 * @author Matthew Lindberg
 */
class ResponsibilityView extends View
{
	/**
	 * Constructor.
	 *
	 * @access public
	 * @return void
	 */
	function ResponsibilityView(& $timer, & $respon_model)
	{
		global $__CS;
		$__CS->EnterMethod("ResponsibilityView");
		$__CS->SendObject($timer,"StopWatch");
		$__CS->SendObject($deed_model,"ResponsibilityModel");
		
		// instantiate parent class
		parent::View(& $timer, & $respon_model);
		
		// Set all template variables
		$this->addToPageTitle("Responsibilities");
		// Top main menu selection
		$this->tpl->assign("toolslinkclass","mainmenulinkon");
		
		$__CS->ExitMethod("ResponsibilityView");
	}
	
	/**
	 * Initializes view.
	 *
	 * @access public
	 * @return void
	 */
	function init()
	{
		// Set submenu links
		$this->tpl->assign( "submenu",
					array(
							array( 	"name" 	=> "Members",
									"class" => "submenuoff",
									"href"	=> $this->makeActionLink(__MEMBER,__MEMBER_SEARCH)),
							array( 	"name"	=> "Deeds",
									"class"	=> "submenuoff",
									"href"	=> $this->makeActionLink(__DEED,__DEED_SEARCH)),
							array(  "name"	=> "Responsibilities",
									"class" => "submenuon",
									"href"  => $this->makeActionLink(__RESPON,__RESPON_SEARCH))
						  )
						   );
	}
	
	/**
	 * Returns html breadcrumb trail link.
	 *
	 * @access public
	 * @return string
	 */
	function getBreadcrumbs()
	{
		return "<a href=".__SITE_BASE_URL."index.php?".__MODULE."=".__RESPON.">responsibilities</a>";
	}

}
?>