<?php
// ErrorView.php
include('core/views/View.php');

/** 
 * Display view for when an error occurs. 
 *
 */
class ErrorView extends View
{
	var $error_msgs;
	
	/**
	 * Constructor.
	 *
	 * @param $timer StopWatch
	 * @param $model Model
	 * @param $err_msgs array
	 * @access public
	 */
	function ErrorView(& $timer, & $model, $err_msgs)
	{
		global $__CS;
		$__CS->EnterMethod("ErrorView");
		$__CS->SendVar($err_msgs,"err_msgs");
		$__CS->SendObject($timer,"timer");
		$__CS->SendObject($model,"model");
		
		// instantiate parent class
		parent::View(& $timer, & $model);
		
		$this->addToPageTitle("___ERROR");
		$this->setTemplate("error.tpl");
		$this->error_msgs = $err_msgs;
		$this->_initTemplate();
		
		$__CS->ExitMethod("ErrorView");
	}
	
	/**
	 * Sets all the Smarty template variables for this View.
	 *
	 * 
	 * @access private
	 */
	function _initTemplate()
	{
		$this->tpl->assign( "errors", $this->error_msgs );
	}
	
}
?>