<?php
// DBRowCollection.php
include_once('lib/util/Collection.php');

/**
 * A collection of database query results
 *
 */
class DBRowCollection extends Collection
{
	// SQL query
	var $query;
	
	// array of DBRow results
	var $result;
	
	/**
	 * Creates a new DBRowCollection
	 *
	 * @param $da DataAccess object
	 * @param $sql string
	 * @access public
	 * @return DBRowCollection
	 */
	function DBRowCollection(& $da, $sql)
	{
		global $__CS;
		$__CS->EnterMethod("DBRowCollection");
		$__CS->SendObject($da,"DataAccess");
		$__CS->SendVar($sql,"sql");
		$__CS->SendSQL($sql);
		
		$this->query = $sql;
		$this->result =& $da->query($sql);
		
		$__CS->ExitMethod("DBRowCollection");
	}
	
	/******
	 * Gets a DBRow row from this Collection by index.
	 *
	 * @param $item int
	 * @access public
	 * @return DBRow
	 */
	function & get($item)
	{
		global $__CS;
		$__CS->EnterMethod("get");
		$__CS->SendVar($item,"item");
		
		// Check that $row is within bounds of results
		if( ($item >= 0) && ($item < $this->size() ) ) {
			$__CS->ExitMethod("get");
			return $this->result[$item];
		}
		else {
			$__CS->SendNote("Index ".$item." is outside the bounds of this Collection");
			$__CS->ExitMethod("get");
			return false;
		}
	}
	
	
	/******
	 * The number of items in the Collection.
	 *
	 * @access public
	 * @return int
	 */
	function size()
	{
		global $__CS;
		$__CS->EnterMethod("size");
		$__CS->ExitMethod("size");
		
		return 	$this->result
				? count($this->result)
				: 0;
	}
	
	/**
	 * Creates a new Iterator for traversing Collection.
	 *
	 * @access public
	 * @return Iterator
	 */
	function & createIterator()
	{
		global $__CS;
		$__CS->EnterMethod("createIterator");
		
		include_once('lib/util/Iterator.php');
		
		$iterator =& new Iterator(& $this);
		
		$__CS->ExitMethod("createIterator");
		return $iterator;
	}
	
}



?>