<?php
// SmartyTemplate.php


/**
 * Wrapper for the Smarty template class.  Takes care of Smartys initialization sequence,
 * setting template variables, and changing/displaying Smarty templates.
 *
 * @author Matthew Lindberg
 */
class SmartyTemplate
{
	var $smarty_class;
	var $smarty_engine;
	var $smarty_template;
	
	/**
	 * Constructs a new Smarty template.
	 *
	 * @param $template string
	 * @access public
	 */
	function SmartyTemplate($template) 
	{
		global $__CS;
		$__CS->EnterMethod("SmartyTemplate");
		$__CS->SendVar($template,"template");
		
		$this->smarty_class = SMARTY_DIR.'Smarty.class.php';
		include_once($this->smarty_class);
		$this->smarty_engine = new Smarty();
		$this->smarty_engine->template_dir = SMARTY_TEMPLATE_DIR;
		$this->smarty_engine->compile_dir = SMARTY_COMPILE_DIR;
		$this->smarty_engine->config_dir = SMARTY_CONFIG_DIR;
		$this->smarty_engine->cache_dir = SMARTY_CACHE_DIR;
		$this->setTemplate($template);
		
		$__CS->ExitMethod("SmartyTemplate");
	}
	
	/**
	 * Assigns a new Smarty variable name and value.
	 *
	 * @param $name string
	 * @param $value string / integer / array
	 * @access public
	 */
	function assign($name, $value)
	{
		global $__CS;
		$__CS->EnterMethod("assign");
		$__CS->SendVar($name,"name");
		$__CS->SendVar($value,"value");
		
		$this->smarty_engine->assign($name, $value);
		
		$__CS->ExitMethod("assign");
	}
	
	/**
	 * Displays the Smarty template file.
	 *
	 * @access public
	 */
	function display()
	{
		global $__CS;
		$__CS->EnterMethod("display");
		
		$this->smarty_engine->display($this->smarty_template);
		
		$__CS->ExitMethod("display");
	}
	
	/**
	 * Sets a new template file to render.
	 *
	 * @param $template_file string
	 */
	function setTemplate($template_file)
	{
		global $__CS;
		$__CS->EnterMethod("setTemplate");
		
		$this->smarty_template = $template_file;
		
		$__CS->ExitMethod("setTemplate");
	}

}

?>