<?php
// Iterator.php

/**
 * Iterator for traversing a Collection.
 *
 */
class Iterator
{
	// Collection
	var $collection;
	
	// int
	var $position;
	
	/**
	 * Constructor.
	 *
	 * @param $collection Collection
	 * @access public
	 */
	function Iterator( & $collection )
	{
		global $__CS;
		$__CS->EnterMethod("Iterator");
		$__CS->SendObject($collection, "Collection");
		
		$this->collection =& $collection;
		$this->first();
		
		$__CS->ExitMethod("Iterator");
	}
	
	/**
	 * Moves pointer to the first element in the collection.
	 *
	 * @access public
	 */
	function first()
	{
		global $__CS;
		$__CS->EnterMethod("first");
		
		$this->position = 0;
		
		$__CS->ExitMethod("first");
	}
	
	/**
	 * Moves the Iterator forward one Collection element.
	 *
	 * @access public
	 */
	function forward()
	{
		global $__CS;
		$__CS->EnterMethod("forward");
		
		$this->position++;
		
		$__CS->ExitMethod("forward");
	}
	
	/**
	 * Fetches the Collection item that the Iterator is currently pointed to.
	 *
	 * @access public
	 */
	function & fetch()
	{
		global $__CS;
		$__CS->EnterMethod("fetch");
		
		if( !($this->isDone()) ) {
			$i = $this->position;
			$this->forward();
			$__CS->ExitMethod("fetch");
			return $this->collection->get($i);
		}
		else {
			$__Cs->SendError("Iterator is past the end of the collection");
			$__CS->ExitMethod("fetch");
			return false;
		}
	}
	
	/** 
	 * Checks whether the Iterator is past the end of the colleciton.
	 *
	 * @access public
	 */
	function isDone()
	{
		global $__CS;
		$__CS->EnterMethod("isDone");
		
		if( $this->position >= $this->collection->size() ) {
			$__CS->ExitMethod("isDone");
			return true;
		}
		else {  
			$__CS->ExitMethod("isDone");
			return false;  
		}
	}
}
?>