<?php
// Request.php


/**
 * A wrapper for any GET and POST request variables so all can be accessed in the same manner.
 * Checks for php magic_quotes and ensures that all requests are raw.
 * Checks for variable conflicts between GET and POST.
 *
 * @author Matthew Lindberg
 */
class Request
{
	// associative array of $key => $request
	var $requests;
	
	
	/**
	 * Constructor.
	 *
	 * @access public
	 */
	function Request()
	{
		global $__CS; 
		$__CS->EnterMethod("Request");
		
		$this->requests = array();
		$this->_wrapRequest();
		
		$__CS->ExitMethod("Request");
	}
	
	
	/**
	 * Gets a request variable if it exists.
	 *
	 * @param $name string
	 * @access public
	 */
	function get($name)
	{
		global $__CS; 
		$__CS->EnterMethod("get");
		$__CS->SendVar($name,"name");
		
		if( !array_key_exists($name,$this->requests) ) {
			return false;
		}
		$__CS->ExitMethod("get");
		return $this->requests[$name];
	}
	
	
	
	/**
	 * Sets a request variable.
	 *
	 * @param $name string
	 * @param $value 
	 * @access public
	 */
	function set($name,$value)
	{
		global $__CS; 
		$__CS->EnterMethod("set");
		$__CS->SendVar($name,"name");
		$__CS->SendVar($value,"value");
		
		$this->requests[$name] = $value;
		
		$__CS->ExitMethod("set");
	}
	
	/**
	 * Checks if a request variable has been set.
	 *
	 * @param $name string
	 * @access public
	 * @return boolean
	 */
	function keyExists($name)
	{
		return ($this->get($name) != null);
	}
	
	/**
	 * Adds a feedback message to an executing request.
	 *
	 */
	function addFeedback($msg)
	{
		if($this->keyExists(__FEEDBACK)) {
			$feedback = $this->get(__FEEDBACK);
			$feedback[] = $msg;
			$this->set(__FEEDBACK,$feedback);
		}
		else {
			$this->set(__FEEDBACK,array($msg));
		}
	}
	
	/**
	 * Checks if the request has feedback.
	 */
	function hasFeedback()
	{
		return $this->keyExists(__FEEDBACK);
	}
	
	/**
	 * Gets a requests feedback array.
	 */
	function getFeedback()
	{
		return $this->get(__FEEDBACK);
	}
	
	/**
	 * Wraps all GET and POST variables into a single request array.
	 *
	 * @access private
	 */
	function _wrapRequest()
	{	
		global $__CS; 
		$__CS->EnterMethod("_wrapRequest");
		
		foreach ($_GET as $key => $value) {
			if( array_key_exists($key, $_POST) ) {
				//$this->_setError("Request:_wrapRequest:  request key conflict, ".$key." exists in both POST and GET arrays.");
				//return false;
			}
			$this->requests[$key] = $this->_getRawGet($key);
		}
		foreach ($_POST as $key => $value) {
			if(is_array($_POST[$key])) {
				$this->requests[$key] = $_POST[$key];
			}
			else {
				$this->requests[$key] = $this->_getRawPost($key);
			}
		}
		
		$__CS->ExitMethod("_wrapRequest");
		return true;
	}
	
	
	/**
	 * Gets a raw POST variable.
	 * 
	 * @param $name string
	 * @access private
	 */
	function _getRawPost( $name )
	{
		global $__CS; 
		$__CS->EnterMethod("_getRawPost");
		$__CS->SendVar($name,"name");
		
		$__CS->ExitMethod("_getRawPost");
		return 	ini_get('magic_quotes_gpc')
		  		? stripslashes($_POST[$name])
		   		: $_POST[$name];
	}
	
	
	/**
	 * Gets a raw GET variable.
	 *
	 * @param $name string
	 * @access private
	 */
	function _getRawGet( $name )
	{
		global $__CS; 
		$__CS->EnterMethod("_getRawGet");
		$__CS->SendVar($name,"name");
		
		$__CS->ExitMethod("_getRawGet");
		return 	ini_get('magic_quotes_gpc')
		  		? stripslashes($_GET[$name])
		   		: $_GET[$name];
	}
	
	/**
	 * Outputs Request as string.
	 * 
	 * @access public
	 */
	function toString()
	{
	}
}

?>