{* 	alias_edit.tpl
	
	Description:  	Form for editing an existing member alias or for creating a new alias.

	@author 	Matt Lindberg
	@created	04-06-2005
	@modified	04-06-2005
	
	Variable Dictionary
	
	$memberid					- Object: form input - the id of the member
	$aliasid					- Object: form input - the id of the alias
	$backbuttonlink				- url string to attach to the 'back' button
	
	$formaction					- the url to submit main form data to via 'Save'
	$characterimage				- path to character image
	$sex						- Object: form input - 'm' or 'f'
	$charactername				- Object: form input
	$raceid						- Object: form input - race id of main character
	$classid					- Object: form input - class id of main character
	$level						- Object: form input - integer level of main character
	$thottbot					- Object: form input - 'yes' or 'no'
		
	$rankoptions				- associative array of rank options in the form <rank> => <rankid>
	$raceoptions				- associative array of race options in the form <race> => <raceid>
	$classoptions				- associative array of class options in the form <class> => <classid>
	$leveloptions				- associative array of level options in the form <level> => <level>
	$characterpics
		.male					- array of male character pictures
			.raceid
			.picfile
		.female					- array of female character pictures
			.raceid
			.picfile
	$editexisting				- "true" if the form is being used to edit a currently existing deed
*}
{include file="header.tpl"}
{* Add Extra Left Column Content Starting Here *}


{* End Left Column Content *}
</div>

{* Start Right Column Content *}
<div id="rightcolumn">
{include file="actiontitle.tpl"}



<SCRIPT type="text/javascript">
{* Changes the character avatar displayed in a member edit form using a sex radio box and and race drop-down menu *}
{literal}
function showCharacterImage() {
	<!--
	if( !document.images ) {
		return false;
	}
	else {
		var race = document.memberedit.{/literal}{$raceid->name}{literal}.options[document.memberedit.{/literal}{$raceid->name}{literal}.selectedIndex].value;
		var sex = null;
		if(document.memberedit.{/literal}{$sex->name}{literal}.length) {
			for( var i=0; i < document.memberedit.{/literal}{$sex->name}{literal}.length; i++) {
				if( document.memberedit.{/literal}{$sex->name}{literal}[i].checked) {
					sex = document.memberedit.{/literal}{$sex->name}{literal}[i].value;
				}
			}
		}
		document.images.characterimage.src = charpics[sex][race];
		return true;
	}
	-->
}
{/literal}


{* Initialize the character picture arrays *}
var charpics = new Array();
var malepics = new Array();
var fempics = new Array();

{section name=fempictures loop=$characterpics.female}
fempics[{$characterpics.female[fempictures].raceid}] = "{$characterpics.female[fempictures].picfile}";
{/section}

{section name=malepictures loop=$characterpics.male}
malepics[{$characterpics.male[malepictures].raceid}] = "{$characterpics.male[malepictures].picfile}";
{/section}

charpics["m"] = malepics;
charpics["f"] = fempics;

</SCRIPT>

<div id="backbutton"><a href="{$backbuttonlink}"">Back</a></div>

<!-- Begin main member editing section -->
<form name="memberedit" action="{$formaction}" method="POST">
<table>
<tr>
	<td></td>
	<th>Character Information</th>
	<td></td>
</tr>
<tr>
	<td><label for="">Name</label></td>
	<td colspan="2">
	<input name="{$charactername->name}" type="text" size="60" value="{$charactername->value}" class="textFormInputBox"/>
	</td>
</tr>
<tr>
	<td><label for="">Sex</label></td>
	<td colspan="2">
	<span>male</span>
	<input name="{$sex->name}"  type="radio" value="m" {if $sex->value == "m"}checked{/if} onClick="showCharacterImage()"/>&nbsp;
	<span>female</span>
	<input name="{$sex->name}"  type="radio" value="f" {if $sex->value == "f"}checked{/if} onClick="showCharacterImage()"/>&nbsp;
	</td>
</tr>
<tr>
	<td><label for="">Race</label></td>
	<td>
	<select name="{$raceid->name}" class="textFormInputBox" onChange="showCharacterImage()">
	{html_options options=$raceoptions selected=$raceid->value}
	</select>
	</td>
	<td>
	<img name="characterimage" src="{$characterimage}">
	</td>
</tr>
<tr>
	<td><label for="">Class</label></td>
	<td colspan="2">
	{html_options class=textFormInputBox name=$classid->name options=$classoptions selected=$classid->value}
</td>
</tr>
<tr>
	<td><label for="">Level</label></td>
	<td colspan="2">
	{html_options class=textFormInputBox name=$level->name options=$leveloptions selected=$level->value}
	</td>
</tr>
<tr>
	<td><label for="">Enable thottbot profile link?</label></td>
	<td colspan="2">
	<span>yes</span>
	<input name="{$thottbot->name}" {if $thottbot->value == "1"}checked{/if} type="radio" value="1"/>&nbsp;
	<span>no</span>
	<input name="{$thottbot->name}" {if $thottbot->value == "0"}checked{/if} type="radio" value="0"/>&nbsp;
	</td>
</tr>
<tr>
	<td></td>
	<td colspan="2"><input type="submit" name="Submit" value="Save" class="buttonSubmit"/></td>
</tr>
<input type="hidden" name="{$memberid->name}" value="{$memberid->value}"/>
<input type="hidden" name="{$aliasid->name}" value="{$aliasid->value}"/>
</table>
</form>
<!-- End new member form -->


</div>
{include file="footer.tpl"}
<script type="text/javascript">
showCharacterImage();
</script>