{* 	deed_find.tpl
	
	Description:  	A paginated listing of deeds.  Each listing is only a summary of
					the full deed.

	@author 	Matt Lindberg
	@created	02-25-2005
	@modified	02-25-2005
	
	Variable Dictionary

	$rightcolumntitle		- title displayed in upper-left corner of right content column
	$totaldeeds				- the total # of deeds found
	$linkallpageback		- hyperlink, if == 'none' will not be displayed
	$linkonepageback		- ''
	$linkallpageforward		- ''
	$linkonepageforward		- ''
	$deed					- array of deed information
		.name
		.description
		.linkedit
		.linkdetail
		.linkdelete
		.difficulty
		.gpguild
		.gpquest
		.gppvp
	$pagenumber
	$totalpages
	$searchtype				- basicsearch | advancedsearch
*}

{include file="header.tpl"}
{* Add Extra Left Column Content Starting Here *}


{* End Left Column Content *}
</div>


{* Start Right Column Content *}
<div id="rightcolumn">

{include file="actiontitle.tpl"}


{* Start Find Deed List *}
<table class="searchresult">
	<tr class="searchresultpages">
		<td>{$totaldeeds} deeds found</td>
		<td class="pagenumber" colspan="3">
		
		{if $linkallpageback eq none}
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		{else}
		<a href="{$linkallpageback}">&lt;&lt;</a>&nbsp;&nbsp;&nbsp;
		{/if}
		
		{if $linkonepageback eq none}
		&nbsp;&nbsp;
		{else}
		<a href="{$linkonepageback}">&lt;&nbsp;</a>
		{/if}
		
		page {$pagenumber} of {$totalpages} 
		
		{if $linkonepageforward eq none}
		&nbsp;&nbsp;&nbsp;&nbsp;
		{else}
		<a href="{$linkonepageforward}">&gt;</a>&nbsp;&nbsp;&nbsp;
		{/if}
		
		{if $linkallpageforward eq none}
		&nbsp;&nbsp;
		{else}
		<a href="{$linkallpageforward}">&gt;&gt;</a></td>
		{/if}
		
	</tr>
	
	<tr classs="searchresultheader">
		<th>Name and Description</th>
		<th>Difficulty</th>
		<th>Guild Points</th>
		<th>Actions</th>
	</tr>
	
	<!-- A single deed summary element, along with admin buttons on the bottom -->
	{section name=deednum loop=$deed}
	<tr class="searchresultelement">
		<td width="300"><a href="{$deed[deednum].linkdetail}">{$deed[deednum].name}</a><br/>{$deed[deednum].description|replace:"\n":"<br/>"}</td>
		<td>{$deed[deednum].difficulty}</td>
		<td class="statbox">
			<table>
				<tr>
					<td class="statname">Guild:</td>
					<td class="statvalue">{$deed[deednum].gpguild}</td>
				</tr>
				<tr>
					<td class="statname">Quest:</td>
					<td class="statvalue">{$deed[deednum].gpquest}</td>
				</tr>
				<tr>
					<td class="statname">Pvp:</td>
					<td class="statvalue">{$deed[deednum].gppvp}</td>
				</tr>
				<tr>
					<td class="statname">Total:</td>
					<td class="statvalue">{$deed[deednum].gpguild+$deed[deednum].gpquest+$deed[deednum].gppvp}</td>
				</tr>
			</table>
		</td>
		<td class="searchresultaction">
			<a href="{$deed[deednum].linkedit}">edit</a><br/>
			<a href="#" onClick="javascript:confirmRequest('{$deed[deednum].linkdelete}','Do you really want to delete this deed?\n\nThis cannot be undone.');">delete</a>
		</td>
	</tr>
	
	<tr>
		<td colspan="4"><hr class="searchresultseperator"/></td>
	</tr>
	{/section}
	<!-- End a deed summary element -->
	
	<tr class="searchresultpages">
		<td>{$totaldeeds} deeds found</td>
		<td class="pagenumber" colspan="3">
		
		{if $linkallpageback eq none}
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		{else}
		<a href="{$linkallpageback}">&lt;&lt;</a>&nbsp;&nbsp;&nbsp;
		{/if}
		
		{if $linkonepageback eq none}
		&nbsp;&nbsp;
		{else}
		<a href="{$linkonepageback}">&lt;&nbsp;</a>
		{/if}
		
		page {$pagenumber} of {$totalpages} 
		
		{if $linkonepageforward eq none}
		&nbsp;&nbsp;&nbsp;&nbsp;
		{else}
		<a href="{$linkonepageforward}">&gt;</a>&nbsp;&nbsp;&nbsp;
		{/if}
		
		{if $linkallpageforward eq none}
		&nbsp;&nbsp;
		{else}
		<a href="{$linkallpageforward}">&gt;&gt;</a></td>
		{/if}
		
	</tr>
</table>

{* End Find Deed List *}


</div>
{include file="footer.tpl"}