{* 	member_find.tpl
	
	Description:  	A paginated listing of members.  

	@author 	Matt Lindberg
	@created	04-06-2005
	@modified	04-06-2005
	
	Variable Dictionary

	$totalmembers			- the total # of members found
	$linkallpageback		- hyperlink, if == 'none' will not be displayed
	$linkonepageback		- ''
	$linkallpageforward		- ''
	$linkonepageforward		- ''
	$members				- array of member information
		.name
		.rank
		.race
		.class
		.level
		.guilddptotal
		.questdptotal
		.pvpdptotal
		.deletelink
		.editlink
		.aliases[]
			.name
			.link
	$pagenumber
	$totalpages
*}

{include file="header.tpl"}
{* Add Extra Left Column Content Starting Here *}


{* End Left Column Content *}
</div>


{* Start Right Column Content *}
<div id="rightcolumn">

{include file="actiontitle.tpl"}


<table class="searchresult">
	<tr class="searchresultpages">
		<td>{$totalmembers} members found</td>
		<td class="pagenumber" colspan="4">
		
		{if $linkallpageback eq none}
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		{else}
		<a href="{$linkallpageback}">&lt;&lt;</a>&nbsp;&nbsp;&nbsp;
		{/if}
		
		{if $linkonepageback eq none}
		&nbsp;&nbsp;
		{else}
		<a href="{$linkonepageback}">&lt;&nbsp;</a>
		{/if}
		
		page {$pagenumber} of {$totalpages} 
		
		{if $linkonepageforward eq none}
		&nbsp;&nbsp;&nbsp;&nbsp;
		{else}
		<a href="{$linkonepageforward}">&gt;</a>&nbsp;&nbsp;&nbsp;
		{/if}
		
		{if $linkallpageforward eq none}
		&nbsp;&nbsp;
		{else}
		<a href="{$linkallpageforward}">&gt;&gt;</a></td>
		{/if}
		
	</tr>
	
	<tr class="searchresultheader">
		<th sytle="width: 20%">Member</th>
		<th style="width: 20%">Stats</th>
		<th style="width: 20%">Deedpoints</th>
		<th style="width: 20%">Aliases</th>
		<th style="width: 20%">Actions</th>
	</tr>
	
	{section name=allmembers loop=$members}
	<!-- A single deed summary element, along with admin buttons on the bottom -->
	<tr class="searchresultelement">
	
		<td style="text-align: center; width: 96px;">
			<img src="{$members[allmembers].characterimgfile}"><br/>{$members[allmembers].name}<br/>{$members[allmembers].rank}
		</td>
		<td class="statbox">
			<table>
				<tr>
					<td class="statname">Race:</td>
					<td class="statvalue">{$members[allmembers].race}</td>
				</tr>
				<tr>
					<td class="statname">Class:</td>
					<td class="statvalue">{$members[allmembers].class}</td>
				</tr>
				<tr>
					<td class="statname">Level:</td>
					<td class="statvalue">{$members[allmembers].level}</td>
				</tr>
			</table>
		</td>
		<td class="statbox">
			<table>
				<tr>
					<td class="statname">Guild:</td>
					<td class="statvalue">{$members[allmembers].guilddptotal}</td>
				</tr>
				<tr>
					<td class="statname">Quest:</td>
					<td class="statvalue">{$members[allmembers].questdptotal}</td>
				</tr>
				<tr>
					<td class="statname">Pvp:</td>
					<td class="statvalue">{$members[allmembers].pvpdptotal}</td>
				</tr>
				<tr>
					<td class="statname">Total:</td>
					<td class="statvalue">{$members[allmembers].guilddptotal+$members[allmembers].questdptotal+$members[allmembers].pvpdptotal}</td>
				</tr>
			</table>
		</td>
		<td>
			{section name=aliaslinks loop=$members[allmembers].aliases}
			<a class="anchorFunction" href="{$members[allmembers].aliases[aliaslinks].link}">{$members[allmembers].aliases[aliaslinks].name}</a><br/>
			{/section}
		</td>
		<td class="searchresultaction">
			<a class="anchorFunction" onClick="javascript:confirmRequest('{$members[allmembers].deletelink}','Do you really want to delete this member?\n\nThis cannot be undone.');" href="#">delete</a><br/>
			<a class="anchorFunction" href="{$members[allmembers].editlink}">edit</a><br/>
			<br/>
		</td>	
	</tr>
	<tr>
		<td colspan="5"><hr class="searchresultseperator"/></td>
	</tr>
	<!-- End a deed summary element -->
	{/section}

	
	<tr class="searchresultpages">
		<td>{$totalmembers} members found</td>
		<td class="pagenumber" colspan="4">
		
		{if $linkallpageback eq none}
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		{else}
		<a href="{$linkallpageback}">&lt;&lt;</a>&nbsp;&nbsp;&nbsp;
		{/if}
		
		{if $linkonepageback eq none}
		&nbsp;&nbsp;
		{else}
		<a href="{$linkonepageback}">&lt;&nbsp;</a>
		{/if}
		
		page {$pagenumber} of {$totalpages} 
		
		{if $linkonepageforward eq none}
		&nbsp;&nbsp;&nbsp;&nbsp;
		{else}
		<a href="{$linkonepageforward}">&gt;</a>&nbsp;&nbsp;&nbsp;
		{/if}
		
		{if $linkallpageforward eq none}
		&nbsp;&nbsp;
		{else}
		<a href="{$linkallpageforward}">&gt;&gt;</a></td>
		{/if}
		
	</tr>
</table>


</div>