{* 	rank_ladder.tpl
	
	Description:  	The graphical ladder representation of the member ranking hierarchy.  Each rank name and promotional path
			between ranks is a clickable element that opens a submenu of functions for ranks and promotional paths.

	@author 	Matt Lindberg
	@created	03-28-2005
	@modified	04-02-2005
	
	Variable Dictionary
	
	$totalmembers			- the total number of members
	$laddercount				- count of the ladder array
	$ladder					- array of alternating rank/promotion path data.  $ladder[0] contains the highest rank, $ladder[1]
						  contains the promotion path data for moving to the highest rank.
		[type rank] 		- (** even indices **)
		.rankname
		.rankid
		.moveuplink
		.movedownlink
		.deletelink
		.numbermembers
		.displayid			- must be unique; used for the id of a rank section element
		.rankmembers			- array of members that have this rank
			.membername
			.memberid
			.memberclass
			.demotelink
			.editlink
		.rankresponsibilitylisteditlink
		.rankresponsibilitylist		- array of rank responsibilities
			.respontext
			.responid
			.removelink
			.detailslink
			.intervalvalue
			.intervaltype
		[type promotion path] - (** odd indices **)
		.fromrank
		.torank
		.displayid			- must be unique; used for the id of a promotion path section
		.promopathdeedlisteditlink
		.promopathdeedlist		- array of completed deeds requried for promotional eligibility
			.deeddesc
			.detailslink
		.deedpointseditlink
		.guilddeedpoints
		.questdeedpoints
		.pvpdeedpoints
		.promopathmembers
			.membername
			.memberid
			.memberclass
			.promotelink
			.editlink
	$formaction				- url to send add rank form to for processing
*}
{include file="header.tpl"}
{* Add Extra Left Column Content Starting Here *}


{* End Left Column Content *}
</div>

{* Start Right Column Content *}
<div id="rightcolumn">
{include file="actiontitle.tpl"}

<SCRIPT type="text/javascript">
// Write javascript toggler arrays for the rank and promotion path detail boxes
// Create an 'ON' array to turn on a rank or promotion path and send to the javascript toggleMultiDisplay() method
// Create an 'OFF' array and fill it will all other section ids
{section name=ladderdisplay loop=$ladder}
var {$ladder[ladderdisplay].displayid}On = new Array("{$ladder[ladderdisplay].displayid}");
var {$ladder[ladderdisplay].displayid}Off = new Array(
{section name=ladderdisplay2 loop=$ladder}
{if $smarty.section.ladderdisplay.index != $smarty.section.ladderdisplay2.index}
"{$ladder[ladderdisplay2].displayid}"
{if $smarty.section.ladderdisplay.last}
	{if $smarty.section.ladderdisplay2.index < $smarty.section.ladderdisplay2.total-2},{/if}
{else}
	{if $smarty.section.ladderdisplay2.index < $smarty.section.ladderdisplay2.total-1},{/if}
{/if}
{/if}
{/section}
);
{/section}
</SCRIPT>


<table class="tableContentLayout">
<tr>
{* Begin rendering ladder *}
<td style="vertical-align: top" width="45%">
<table class="tableContentLayout">
{section name=ladderrows loop=$ladder}
{if $smarty.section.ladderrows.index%2 == 0}
<tr>
	<td style="text-align:right; text-decoration: none;">
		{if $smarty.section.ladderrows.first}
		<a class="imageAnchor" href="#"><img src="./img/arrow_down_move.png"></a>
		{elseif $smarty.section.ladderrows.last}
		<a class="imageAnchor" href="#"><img src="./img/arrow_up_move.png"></a>
		{else}
		<a class="imageAnchor" href="#"><img src="./img/arrow_down_move.png"></a>&nbsp;&nbsp;&nbsp;
		<a class="imageAnchor" href="#"><img src="./img/arrow_up_move.png"></a>
		{/if}
		
	</td>
	<td style="text-align: center">
		<a class="anchorRanktitle" onClick="return toggleMultiDisplay({$ladder[ladderrows].displayid}On,{$ladder[ladderrows].displayid}Off);" href="#">
		{$ladder[ladderrows].rankname}</a>
	</td>
	<td></td>
	<td></td>
</tr>
{else}
<tr>
	<td></td>
	<td style="text-align: center">
		<a class="imageAnchor" href="#" onClick="return toggleMultiDisplay({$ladder[ladderrows].displayid}On,
		{$ladder[ladderrows].displayid}Off);"><img src="./img/promotion_arrow_up.png"></a>
	</td>
	<td></td>
	<td></td>
</tr>
{/if}
{/section}
</table>
</td>
<td valign="top">
{* End rendering ladder *}

{* Begin rendering the detail sections for ranks and promotion paths *}
{section name=laddersections loop=$ladder}
{if $smarty.section.laddersections.index%2 == 0}  {* If the section index is even, it is a rank *}
<!-- Begin rank editing box -->
<div class="boxRankEditCell" id="{$ladder[laddersections].displayid}">
<table width="100%">
	<tr>
		<td>
			<span class="spanRankSelectionText">Rank: {$ladder[laddersections].rankname}</span>
		</td>
		<td style="text-align: right;">
			<a class="anchorFunction" href="{$ladder[laddersections].deletelink}">delete</a>
		</td>
	</tr>
</table>
<br/>
<table class="tableRankDetails" width="100%">
{section name=memberdetails loop=$ladder[laddersections].rankmembers}
{if $smarty.section.memberdetails.first}
<!-- Begin statistics section -->
<tr>
	<th colspan="2"># members</th>
	<th>% of total</th>
</tr>
<tr>
	<td colspan="2" class="cellData">{$smarty.section.memberdetails.total}/{$totalmembers}</td>
	<td class="cellData" style="text-align: right">{$smarty.section.memberdetails.total/$totalmembers}%</td>
</tr>
<!-- End statistics section -->
<!-- Begin active members section -->
<tr>
	<th>Members</th>
	<th>class</th>
	<th></th>
</tr>
{/if}
<tr>
	<td>{$ladder[laddersections].rankmembers[memberdetails].membername}</td>
	<td>{$ladder[laddersections].rankmembers[memberdetails].memberclass}</td>
	<td style="text-align: right">
	<a class="anchorFunction" href="{$ladder[laddersections].rankmembers[memberdetails].demotelink}">demote</a>&nbsp;&nbsp;
	<a class="anchorFunction" href="{$ladder[laddersections].rankmembers[memberdetails].editlink}">edit</a>
	</td>
</tr>
{/section}
<!-- End active members section -->
<!-- Begin responsibilities section -->
<tr>
	<th colspan="1">Responsibilities</th>
	<th colspan="1">every</th>
	<th></th>
</tr>
<tr>
	<td colspan="3"><a class="anchorFunction" href="{$rankresponsibilityeditlist}">edit list</a></td>
</tr>
{section name=memberrespon loop=$ladder[laddersections].rankresponsibilitylist}
<tr>
	<td>{$ladder[laddersections].rankresponsibilitylist[memberrespon].respontext}</td>
	<td class="cellData">{$ladder[laddersections].rankresponsibilitylist[memberrespon].invervalvalue} {$ladder[laddersections].rankresponsibilitylist[memberrespon].invervaltype}</td>
	<td style="text-align: right">
	<a class="anchorFunction" href="{$ladder[laddersections].rankresponsibilitylist[memberrespon].removelink}">remove</a>&nbsp;&nbsp;
	<a class="anchorFunction" onclick="{$ladder[laddersections].rankresponsibilitylist[memberrespon].detailslink}" href="#">details</a>
	</td>
</tr>
{/section}
<!-- End responsibilities section -->
</table>
</div>
<!-- End rank editing box -->
{else} {* If the index is odd, it is a promotion path *}
<!-- Begin promotion path editing box -->
<div class="boxRankEditCell" id="{$ladder[laddersections].displayid}">
<table width="100%">
	<tr>
		<td>
			<span class="spanRankSelectionText">Promotion: {$ladder[laddersections.index_next].rankname} to {$ladder[laddersections.index_prev].rankname} </span></td>
		<td style="text-align: right; vertical-align: top;">
		</td>
	</tr>
</table>
<br/>
<table class="tableRankDetails" width="100%">
<!-- Begin deed requirements section -->
<tr>
	<th colspan="3">Deeds</th>
</tr>
<tr>
	<td colspan="3">
		<a class="anchorFunction" href="{$ladder[laddersections].promopathdeedlisteditlink}">edit list</a>
	</td>
</tr>
{section name=promodeeds loop=$ladder[laddersections].promopathdeedlist}
<tr>
	<td colspan="2">
	{$ladder[laddersections].promopathdeedlist[promodeeds].deeddesc}
	</td>
	<td style="text-align: right">
	<a class="anchorFunction" href="#" onClick="{$ladder[laddersections].promopathdeedlist[promodeeds].detailslink}">details</a>
	</td>
</tr>
{/section}
<!-- End deed requirements section -->
<!-- Begin deed points requirement section -->
<tr>
	<th>Deed points</th>
	<th colspan="2">greater than</th>
</tr>
<tr>
	<td colspan="3">
		<a class="anchorFunction" href="{$ladder[laddersections].deedpointseditlink}">edit</a>
	</td>
</tr>
<tr>
	<td>Quest</td>
	<td class="cellData">{$ladder[laddersections].questdeedpoints}</td>
	<td></td>
</tr>
<tr>
	<td>Pvp</td>
	<td class="cellData">{$ladder[laddersections].pvpdeedpoints}</td>
	<td></td>
</tr>
<tr>
	<td>Guild</td>
	<td class="cellData">{$ladder[laddersections].guilddeedpoints}</td>
	<td></td>
</tr>
<!-- End deed points requirement section -->
<!-- Begin eligible members section -->
<tr>
	<th>Eligible members</th>
	<th>class</th>
	<th></th>
</tr>
{section name=eligiblemembers loop=$ladder[laddersections].promopathmembers}
<tr>
	<td>{$ladder[laddersections].promopathmembers[eligiblemembers].membername}</td>
	<td>{$ladder[laddersections].promopathmembers[eligiblemembers].memberclass}</td>
	<td style="text-align: right">
	<a class="anchorFunction" href="{$ladder[laddersections].promopathmembers[eligiblemembers].promotelink}">promote</a>&nbsp;&nbsp;
	<a class="anchorFunction" href="{$ladder[laddersections].promopathmembers[eligiblemembers].editlink}">edit</a>
	</td>
</tr>
{/section}
<!-- End eligible members section -->
</table>
</div>
<!-- End promotion path editing box -->

{/if}
{/section}
{* End rendering details *}

</td>
</tr>

<tr><td colspan="2" height="10px"></td></tr>
<tr><td colspan="2"><hr/></td></tr>


<tr>
<td colspan="2">
<form method="POST" action="#">
<input class="buttonSubmit" type="submit" name="Submit" value="Add new rank"/>
<input class="textFormInputBox" type="text" size="25" name="newrankname"/>
<select>
	<option selected=selected>above</option>
	<option>below</option>
</select>
<select>
	<option selected=selected>Officer</option>
	<option>Veteran</option>
	<option>Outcast</option>
</select>
</form>
</td>
</tr>

</table>

</div>

</div>
<!-- End body -->
</body>
</html>