{* 	responsibility_select_list.tpl
	
	Description:  	A list for selection of multiple responsibilities.  Can be used to select responsibilities for both
					individual members and ranks.

	@author 	Matt Lindberg
	@created	04-05-2005
	@modified	04-05-2005
	
	Variable Dictionary
	
	$ownerid					- the id of the list owner; memberid or rankid
	$owneridname				- name of form input
	$ownertype					- "rank" or "member"
	$backbuttonlink
	$checkboxname				- name of form input
	$completetimename			- name of form input - id of responsibility will be appended to distinguish
	$completetimetypename		- name of form input - id of repsonsibility will be appended to distinguish
	$respon[]					- array of responsibility arrays
		[]	responid
			respondesc
			checked				- 'yes' or 'no'
			detailslink
			completetime
			completetimetype	- "day" or "month" or "year"
	$formaction
	$completetimeoptions[]
	$completetimetypeoptions[]
*}
{include file="header.tpl"}
{* Add Extra Left Column Content Starting Here *}


{* End Left Column Content *}
</div>

{* Start Right Column Content *}
<div id="rightcolumn">
{include file="actiontitle.tpl"}

<div id="backbutton"><a href="{$backbuttonlink}">Back</a></div>
<form method="post" action="{$formaction}">
<table class="searchresult">

<tr>
	<th style="width: 5%"></th>
	<th colspan="2" style="width: 70%">Responsibility Name</th>
	<th style="width: 25%">Complete every</th>
</tr>

{section name=respons loop=$respon}
<tr class="rowTableList1">
	<td>
		<input width="20px" type="checkbox" {if $respon[respons].checked == yes}checked{/if} name="{$checkboxname}[]" value="{$respon[respons].responid}"/>
	</td>
	<td>
		{$respon[respons].respondesc}
	</td>
	</td>
	<td style="text-align: right">
		<a class="anchorFunction" href="{$respon[respons].detailslink}">details</a>
	</td>
	<td>
		<select name="{$completetimename}{$respon[respons].responid}">
		{html_options options=$completetimeoptions selected=$respon[respons].completetime}
		</select>
		<select name="{$completetimetypename}{$respon[respons].responid}">
		{html_options options=$completetimetypeoptions selected=$respon[respons].completetimetype}
		</select>
	</td>
</tr>
{/section}

<tr>
	<td colspan="4">
		<hr/>
		<input type="hidden" name="{$owneridname}" value="{$ownerid}"/>
		<input type="submit" class="buttonSubmit" name="Submit" value="Save Changes"/>
	</td>
</tr>
</table>
</form>
</div>
{include file="footer.tpl"}