<?php
/*
<fusedoc fuse="fbx_Switch.php">
	<responsibilities>
		I am the switch statement that handles the fuseaction, delegating work to various fuses.
	</responsibilities>
	<io>
		<in>
			<string name="$Fusebox['fuseaction']" />
			<string name="$Fusebox['circuit']" />
		</in>
	</io>	
</fusedoc>
*/
//  Admin switchbox
if ($authenticated and $user_admin)
{
	switch($Fusebox["fuseaction"])
	{
		case "main":
			include("includes/dsp_main.inc");
			break;
		case "news":
		case "statistics":
		case "login":
		case "newuser":
			include("includes/dsp_createNewUser.inc");
			break;
		case "deleteuser":
			include("includes/dsp_deleteUser.inc");
			break;
		case "edituser":
			include("includes/dsp_editUser.inc");
			break;
		case "addUserToDatabase":
			include("queries/qry_addUserToDatabase.inc");
			break;
		case "deleteUserFromDatabase":
			include("queries/qry_deleteUserFromDatabase.inc");
			break;
		case "editUserInDatabase":
			include("queries/qry_editUserInDatabase.inc");
			break;
		case "search":
		case "users":
		case "import":
			include("includes/dsp_gedXMLImport.inc");
			break;
		case "approve":
			//include("../functions.php");
			include("includes/dsp_approveData.inc");
			break;
		case "adminCreateUser";
			include("queries/qry_addUserToDatabase.inc");
			include("queries/qry_markAccessRequestHandled.inc");
			header('Location: index.php?fuseaction=admin.approve');
			break;
		case "adminApproveFamily":
			include("queries/qry_approveFamily.inc");
			header('Location: index.php?fuseaction=admin.approve');
			break;
		case "adminApprovePerson":
			include("queries/qry_approvePerson.inc");
			header('Location: index.php?fuseaction=admin.approve');
			break;
		case "adminViewFile":
			include("queries/qry_getFileNameFromID.inc");
			include("queries/qry_viewFile.inc");
			break;
		case "adminImportFile":
			include("queries/qry_getFileNameFromID.inc");
			include("includes/dsp_gedXMLImport.inc");
			include("queries/qry_importFile.inc");
			header('Location: index.php?fuseaction=admin.approve');
			break;
		case "Fusebox.defaultFuseaction":
			print "I received a fuseaction called <b>'" . $Fusebox["fuseaction"] . "'</b> that circuit <b>'" . $Fusebox["circuit"] . "'</b> handles.";
			include("includes/dsp_main.inc");
			break;
		default:
			print "I received a fuseaction called <b>'" . $Fusebox["fuseaction"] . "'</b> that circuit <b>'" . $Fusebox["circuit"] . "'</b> does not have a handler for.";
			break;
	}
}
else
{
	// Bounce user to login screen if they try to access an area that needs authentication.
	header('Location: index.php?fuseaction=main.login');
}
?>
